"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextPropTypes = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var prop_types_1 = __importDefault(require("prop-types"));
var utils_1 = require("../utils");
exports.TextPropTypes = {
    /**
     * `size` prop expects a string which format should be a number which represent the number of `type`'s to indent each content. Default to no indentation.
     */
    size: prop_types_1.default.number,
    /**
     * `type` prop expects a string, you can use the `IndentationTypes` enum, as either `TABS` or `SPACES`. The `type` defaults to `SPACES`.
     */
    type: prop_types_1.default.oneOf(Object.values(utils_1.IndentationTypes)),
    /**
     * `newLines` prop represents the number of appended new lines. Default to one new line.
     */
    newLines: prop_types_1.default.number,
};
/**
 * Component is for defining a group of text which should be rendered on the same line.
 *
 * @component
 * @example
 * const indent = 4
 * const type = IndentationTypes.SPACES
 * const newLines = 2
 * return (
 *   <Text indent={size} type={type} newLines={newLines}>Test</Text>
 * )
 */
var Text = function (_a) {
    var _b = _a.indent, indent = _b === void 0 ? 0 : _b, _c = _a.type, type = _c === void 0 ? utils_1.IndentationTypes.SPACES : _c, _d = _a.newLines, newLines = _d === void 0 ? 1 : _d, childrenContent = _a.childrenContent;
    var contentWithLines = utils_1.withNewLines(childrenContent, newLines);
    return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: utils_1.withIndendation(contentWithLines, indent, type) }, void 0);
};
Text.propTypes = __assign({}, exports.TextPropTypes);
exports.default = Text;
//# sourceMappingURL=Text.js.map