"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var utils_1 = require("../../utils");
var __1 = require("../../");
describe('<File />', function () {
    test('Should always render as is with default ptops', function () {
        var defaultProps = {};
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.File, __assign({}, defaultProps, { children: "Test" }), void 0));
        expect(wrapper).toEqual('Test');
    });
    test('Should alwyas render as is with props', function () {
        var defaultProps = {
            fileName: 'test.ts',
            permissions: 511
        };
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.File, __assign({}, defaultProps, { children: "Test" }), void 0));
        expect(wrapper).toEqual('Test');
    });
    test('Should always be able to render Indent', function () {
        var defaultProps = {};
        var indentProps = {
            size: 4,
            type: utils_1.IndentationTypes.SPACES
        };
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.File, __assign({}, defaultProps, { children: jsx_runtime_1.jsx(__1.Indent, __assign({}, indentProps, { children: "Test" }), void 0) }), void 0));
        expect(wrapper).toEqual('    Test');
    });
    test('Should always be able to render Text', function () {
        var defaultProps = {};
        var textProps = {
            indent: 4,
            type: utils_1.IndentationTypes.SPACES
        };
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.File, __assign({}, defaultProps, { children: jsx_runtime_1.jsx(__1.Text, __assign({}, textProps, { children: "Test" }), void 0) }), void 0));
        expect(wrapper).toEqual('    Test\n');
    });
});
//# sourceMappingURL=File.spec.js.map