"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var utils_1 = require("../../utils");
var __1 = require("../..");
describe('<Text />', function () {
    test('Should always render as is text with default props', function () {
        var defaultProps = {};
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.Text, __assign({}, defaultProps, { children: "Test" }), void 0));
        expect(wrapper).toEqual('Test\n');
    });
    test('Should always render indentation with spaces', function () {
        var defaultProps = {
            indent: 4,
            type: utils_1.IndentationTypes.SPACES
        };
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.Text, __assign({}, defaultProps, { children: "Test" }), void 0));
        expect(wrapper).toEqual('    Test\n');
    });
    test('Should always render indentation with tabs', function () {
        var defaultProps = {
            indent: 2,
            type: utils_1.IndentationTypes.TABS
        };
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.Text, __assign({}, defaultProps, { children: "Test" }), void 0));
        expect(wrapper).toEqual('		Test\n');
    });
    test('Should be able to render nest texts', function () {
        var defaultProps = {};
        var wrapper = __1.render(jsx_runtime_1.jsx(__1.Text, __assign({}, defaultProps, { children: jsx_runtime_1.jsx(__1.Text, __assign({}, defaultProps, { children: "Test" }), void 0) }), void 0));
        expect(wrapper).toEqual('Test\n\n');
    });
});
//# sourceMappingURL=Text.spec.js.map