"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importDefault(require("react"));
var __1 = require("../..");
describe('Renderer', function () {
    test('should render works when element is string', function () {
        var content = __1.render("Test 1");
        expect(content).toEqual("Test 1");
    });
    test('should render works when element is a Funcion Component', function () {
        function Test() {
            return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: "Test 2" }, void 0);
        }
        var content = __1.render(jsx_runtime_1.jsx(Test, {}, void 0));
        expect(content).toEqual("Test 2");
    });
    test('should render works when element is a Class Component', function () {
        var Test = /** @class */ (function (_super) {
            __extends(Test, _super);
            function Test(props) {
                return _super.call(this, props) || this;
            }
            Test.prototype.render = function () {
                return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: "Test 3" }, void 0);
            };
            return Test;
        }(react_1.default.Component));
        var content = __1.render(jsx_runtime_1.jsx(Test, {}, void 0));
        expect(content).toEqual("Test 3");
    });
    test('should render works with nested hierarchy', function () {
        function NestedComponent() {
            return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: "Nested Component" }, void 0);
        }
        function FunctionComponent() {
            return jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: ["Function Component ", jsx_runtime_1.jsx(NestedComponent, {}, void 0), "\n"] }, void 0);
        }
        var ClassComponent = /** @class */ (function (_super) {
            __extends(ClassComponent, _super);
            function ClassComponent(props) {
                return _super.call(this, props) || this;
            }
            ClassComponent.prototype.render = function () {
                return jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: ["Class Component", "\n"] }, void 0);
            };
            return ClassComponent;
        }(react_1.default.Component));
        var content = __1.render(jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: ["some inlined text", "\n", jsx_runtime_1.jsx(FunctionComponent, {}, void 0),
                jsx_runtime_1.jsx(ClassComponent, {}, void 0)] }, void 0));
        expect(content).toEqual("some inlined text\nFunction Component Nested Component\nClass Component\n");
    });
    test('should render works with props', function () {
        function Test(_a) {
            var someProp = _a.someProp;
            if (!someProp) {
                return jsx_runtime_1.jsx(Test, { someProp: "Nested prop" }, void 0);
            }
            return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: someProp }, void 0);
        }
        var content = __1.render(jsx_runtime_1.jsx(Test, {}, void 0));
        expect(content).toEqual("Nested prop");
    });
    test('should render works with null as returned value', function () {
        function Test() {
            return null;
        }
        var content = __1.render(jsx_runtime_1.jsx(Test, {}, void 0));
        expect(content).toEqual("");
    });
    test('should render works nested null value', function () {
        function NullComponent() {
            return null;
        }
        function NestedComponent() {
            return (jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: [jsx_runtime_1.jsx(NullComponent, {}, void 0), "some text"] }, void 0));
        }
        function Component() {
            return (jsx_runtime_1.jsxs(jsx_runtime_1.Fragment, { children: [jsx_runtime_1.jsx(NullComponent, {}, void 0),
                    jsx_runtime_1.jsx(NestedComponent, {}, void 0),
                    jsx_runtime_1.jsx(NullComponent, {}, void 0)] }, void 0));
        }
        var content = __1.render(jsx_runtime_1.jsx(Component, {}, void 0));
        expect(content).toEqual("some text");
    });
    test('should works with array as returned value', function () {
        function Component(_a) {
            var text = _a.text;
            return jsx_runtime_1.jsx(jsx_runtime_1.Fragment, { children: text }, void 0);
        }
        function Test() {
            return [
                jsx_runtime_1.jsx(Component, { text: 'some' }, void 0),
                jsx_runtime_1.jsx(Component, { text: ' text' }, void 0),
                jsx_runtime_1.jsx(Component, { text: ' is rendered' }, void 0),
            ];
        }
        var content = __1.render(jsx_runtime_1.jsx(Test, {}, void 0));
        expect(content).toEqual("some text is rendered");
    });
    test('should throws error due to using React hooks', function () {
        function Component() {
            var _a = react_1.default.useState(), someState = _a[0], setSomeState = _a[1];
            return null;
        }
        var error = undefined;
        try {
            __1.render(jsx_runtime_1.jsx(Component, {}, void 0));
        }
        catch (err) {
            error = err;
        }
        // check substring of the desired error
        expect(error.message).toContain('Invalid hook call.');
    });
    test('should skips internal React components', function () {
        function Component() {
            return (jsx_runtime_1.jsx(react_1.default.Suspense, __assign({ fallback: '...loading' }, { children: "some text" }), void 0));
        }
        var content = __1.render(jsx_runtime_1.jsx(Component, {}, void 0));
        expect(content).toEqual("some text");
    });
    test('should throws error due to using HTML tags', function () {
        function Component() {
            return (jsx_runtime_1.jsx("div", { children: "some text" }, void 0));
        }
        var error = undefined;
        try {
            __1.render(jsx_runtime_1.jsx(Component, {}, void 0));
        }
        catch (err) {
            error = err;
        }
        // check substring of the desired error
        expect(error.message).toEqual('HTML tags is not supported yet.');
    });
});
//# sourceMappingURL=renderer.spec.js.map