"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTemplate = void 0;
var renderer_1 = require("./renderer");
var utils_1 = require("../utils");
/**
 * render a file with react. This function automatically transforms jsx to js before importing the component.
 *
 * @param filepath the path to file to render
 */
function renderTemplate(filepath, context) {
    return __awaiter(this, void 0, void 0, function () {
        var data, component, err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!utils_1.isJsFile(filepath)) {
                        return [2 /*return*/, undefined];
                    }
                    data = undefined;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, , 5]);
                    return [4 /*yield*/, importComponent(filepath)];
                case 2:
                    component = _a.sent();
                    if (component === undefined) {
                        return [2 /*return*/, undefined];
                    }
                    return [4 /*yield*/, component(context)];
                case 3:
                    data = _a.sent();
                    return [3 /*break*/, 5];
                case 4:
                    err_1 = _a.sent();
                    throw err_1;
                case 5:
                    // undefined, null etc. cases
                    if (!data) {
                        return [2 /*return*/, undefined];
                    }
                    if (Array.isArray(data)) {
                        return [2 /*return*/, data.map(function (file) { return file && renderFile(file); }).filter(Boolean)];
                    }
                    return [2 /*return*/, renderFile(data)];
            }
        });
    });
}
exports.renderTemplate = renderTemplate;
/**
 * Imports a given file and return the imported component
 *
 * @private
 * @param filepath to import
 */
function importComponent(filepath) {
    return new Promise(function (resolve, reject) {
        try {
            // we should import component only in NodeJS
            if (require === undefined)
                resolve(undefined);
            // remove from cache imported file
            delete require.cache[require.resolve(filepath)];
            var component = require(filepath);
            if (typeof component === "function")
                resolve(component);
            if (typeof component.default === "function")
                resolve(component.default);
            resolve(undefined);
        }
        catch (err) {
            reject(err);
        }
    });
}
/**
 * Render a single File component.
 *
 * @private
 * @param {React.ReactElement} file to import
 */
function renderFile(file) {
    if (typeof file !== "object") {
        return undefined;
    }
    var type = file.type, _a = file.props, props = _a === void 0 ? {} : _a;
    // if no File component is found as root, don't render it.
    if (typeof type !== "function" || type.name !== "File") {
        return undefined;
    }
    return {
        content: renderer_1.render(props.children),
        metadata: {
            fileName: props.name,
            permissions: props.permissions,
        }
    };
}
//# sourceMappingURL=template.js.map