"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs_1 = __importDefault(require("fs"));
var path_1 = __importDefault(require("path"));
var util_1 = require("util");
var transpiler_1 = require("../transpiler");
var renderer_1 = require("../../renderer");
var readFile = util_1.promisify(fs_1.default.readFile);
describe('Transpiler', function () {
    var testFiles = path_1.default.resolve(__dirname, './testfiles');
    var outputFiles = path_1.default.resolve(__dirname, './__transpiled_testfiles');
    beforeAll(function (done) { return __awaiter(void 0, void 0, void 0, function () {
        var e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, transpiler_1.transpileFiles(testFiles, outputFiles, {
                            recursive: true
                        })];
                case 1:
                    _a.sent();
                    done();
                    return [3 /*break*/, 3];
                case 2:
                    e_1 = _a.sent();
                    console.log(e_1);
                    done(e_1);
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/];
            }
        });
    }); });
    describe('should transpile CommonJS files', function () {
        describe('with a simple setup', function () {
            var commonjs_testFile = path_1.default.resolve(outputFiles, './CommonJS/simple.js');
            var commonjs_testFileMap = path_1.default.resolve(outputFiles, './CommonJS/simple.js.map');
            test('and import correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content, mapContent, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, readFile(commonjs_testFile, 'utf8')];
                        case 1:
                            content = _b.sent();
                            expect(switchToUnixLinebreaks(content)).toMatchSnapshot();
                            return [4 /*yield*/, readFile(commonjs_testFileMap, 'utf8')];
                        case 2:
                            mapContent = _b.sent();
                            expect(switchToUnixLinebreaks(mapContent)).toMatchSnapshot();
                            _a = expect;
                            return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require(commonjs_testFile)); })];
                        case 3:
                            _a.apply(void 0, [_b.sent()]).toBeDefined();
                            return [2 /*return*/];
                    }
                });
            }); });
            test('and render correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content;
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, renderer_1.renderTemplate(commonjs_testFile, { asyncapi: {}, originalAsyncAPI: "", params: {} })];
                        case 1:
                            content = _b.sent();
                            expect((_a = content) === null || _a === void 0 ? void 0 : _a.content).toBe("hello Test");
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    });
    describe('should transpile ES5 files', function () {
        describe('with a simple setup', function () {
            var es5_testFile = path_1.default.resolve(outputFiles, './ES5/simple.js');
            var es5_testFileMap = path_1.default.resolve(outputFiles, './ES5/simple.js.map');
            test('and import correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content, mapContent, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, readFile(es5_testFile, 'utf8')];
                        case 1:
                            content = _b.sent();
                            expect(switchToUnixLinebreaks(content)).toMatchSnapshot();
                            return [4 /*yield*/, readFile(es5_testFileMap, 'utf8')];
                        case 2:
                            mapContent = _b.sent();
                            expect(switchToUnixLinebreaks(mapContent)).toMatchSnapshot();
                            _a = expect;
                            return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require(es5_testFile)); })];
                        case 3:
                            _a.apply(void 0, [_b.sent()]).toBeDefined();
                            return [2 /*return*/];
                    }
                });
            }); });
            test('and render correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content;
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, renderer_1.renderTemplate(es5_testFile, { asyncapi: {}, originalAsyncAPI: "", params: {} })];
                        case 1:
                            content = _b.sent();
                            expect((_a = content) === null || _a === void 0 ? void 0 : _a.content).toBe("hello Test");
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    });
    describe('should transpile ES6 files', function () {
        describe('with a simple setup', function () {
            var es6_testFile = path_1.default.resolve(outputFiles, './ES6/simple.js');
            var es6_testFileMap = path_1.default.resolve(outputFiles, './ES6/simple.js.map');
            test('and import correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content, mapContent, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, readFile(es6_testFile, 'utf8')];
                        case 1:
                            content = _b.sent();
                            expect(switchToUnixLinebreaks(content)).toMatchSnapshot();
                            return [4 /*yield*/, readFile(es6_testFileMap, 'utf8')];
                        case 2:
                            mapContent = _b.sent();
                            expect(switchToUnixLinebreaks(mapContent)).toMatchSnapshot();
                            _a = expect;
                            return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require(es6_testFile)); })];
                        case 3:
                            _a.apply(void 0, [_b.sent()]).toBeDefined();
                            return [2 /*return*/];
                    }
                });
            }); });
            test('and render correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content;
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, renderer_1.renderTemplate(es6_testFile, { asyncapi: {}, originalAsyncAPI: "", params: {} })];
                        case 1:
                            content = _b.sent();
                            expect((_a = content) === null || _a === void 0 ? void 0 : _a.content).toBe("hello Test");
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    });
    describe('should keep names of files, even if special chars', function () {
        describe('with a simple setup', function () {
            var special_testFile = path_1.default.resolve(outputFiles, './SpecialChars/$$simple$$.js');
            var special_testFileMap = path_1.default.resolve(outputFiles, './SpecialChars/$$simple$$.js.map');
            test('and import correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content, mapContent, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, readFile(special_testFile, 'utf8')];
                        case 1:
                            content = _b.sent();
                            expect(switchToUnixLinebreaks(content)).toMatchSnapshot();
                            return [4 /*yield*/, readFile(special_testFileMap, 'utf8')];
                        case 2:
                            mapContent = _b.sent();
                            expect(switchToUnixLinebreaks(mapContent)).toMatchSnapshot();
                            _a = expect;
                            return [4 /*yield*/, Promise.resolve().then(function () { return __importStar(require(special_testFile)); })];
                        case 3:
                            _a.apply(void 0, [_b.sent()]).toBeDefined();
                            return [2 /*return*/];
                    }
                });
            }); });
            test('and render correctly', function () { return __awaiter(void 0, void 0, void 0, function () {
                var content;
                var _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, renderer_1.renderTemplate(special_testFile, { asyncapi: {}, originalAsyncAPI: "", params: {} })];
                        case 1:
                            content = _b.sent();
                            expect((_a = content) === null || _a === void 0 ? void 0 : _a.content).toBe("hello Test");
                            return [2 /*return*/];
                    }
                });
            }); });
        });
    });
});
/*
  It is a helper required for snapshot testing on windows. It can't be solved by editor configuration and the end line setting because snapshots are generated not created in the editor.
  We need to remove `\r` from files transpiled on windows before we can match them with the snapshot generated on unix
*/
function switchToUnixLinebreaks(str) {
    return str.replace(/\\r/g, "");
}
//# sourceMappingURL=transpiler.spec.js.map