"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.transpileFiles = void 0;
var path_1 = __importDefault(require("path"));
var rollup_1 = require("rollup");
var plugin_babel_1 = __importDefault(require("@rollup/plugin-babel"));
var utils_1 = require("../utils");
var ROOT_DIR = path_1.default.resolve(__dirname, '../..');
/**
 * Transpile files in a given directory (and sub directory if recursive option are passed) and write it to an output directory, if no errors are thrown it completed successfully.
 *
 * @param directory to transpile.
 * @param outputDir to write the transpiled files to.
 * @param options any extra options that should be passed.
 */
function transpileFiles(directory, outputDir, options) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, files, dirs, bundles, _i, dirs_1, subdir, subdirPath;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, utils_1.getStatsInDir(directory)];
                case 1:
                    _a = _b.sent(), files = _a.files, dirs = _a.dirs;
                    if (!files.length) return [3 /*break*/, 4];
                    return [4 /*yield*/, rollup_1.rollup({
                            input: files,
                            onwarn: function () { },
                            plugins: [
                                plugin_babel_1.default({
                                    cwd: ROOT_DIR,
                                    babelHelpers: "bundled",
                                    plugins: [
                                        "source-map-support",
                                    ],
                                    presets: [
                                        ["@babel/preset-env", {
                                                targets: { node: "12.16" },
                                            }],
                                        ["@babel/preset-react", {
                                                runtime: "automatic",
                                            }],
                                    ],
                                })
                            ],
                        })];
                case 2:
                    bundles = _b.sent();
                    return [4 /*yield*/, bundles.write({
                            format: "commonjs",
                            sourcemap: true,
                            dir: outputDir,
                            exports: "auto",
                            paths: {
                                'react/jsx-runtime': 'react/cjs/react-jsx-runtime.production.min',
                            },
                            sanitizeFileName: false,
                        })];
                case 3:
                    _b.sent();
                    _b.label = 4;
                case 4:
                    if (!((options === null || options === void 0 ? void 0 : options.recursive) === true && dirs.length > 0)) return [3 /*break*/, 8];
                    _i = 0, dirs_1 = dirs;
                    _b.label = 5;
                case 5:
                    if (!(_i < dirs_1.length)) return [3 /*break*/, 8];
                    subdir = dirs_1[_i];
                    subdirPath = path_1.default.parse(subdir);
                    return [4 /*yield*/, transpileFiles(subdir, path_1.default.resolve(outputDir, subdirPath.base), options)];
                case 6:
                    _b.sent();
                    _b.label = 7;
                case 7:
                    _i++;
                    return [3 /*break*/, 5];
                case 8: return [2 /*return*/];
            }
        });
    });
}
exports.transpileFiles = transpileFiles;
//# sourceMappingURL=transpiler.js.map