import React from "react";
import { AsyncAPIDocument } from "@asyncapi/parser";
export declare type PropsWithChildrenContent<P> = P & {
    childrenContent?: string;
};
export declare type FC<P = {}> = FunctionComponent<P>;
export declare type FunctionComponent<P = {}> = React.FunctionComponent<PropsWithChildrenContent<P>>;
export declare class Component<P = {}> extends React.Component<PropsWithChildrenContent<P>> {
}
/**
 * Shape of the context passed to template
 */
export interface TemplateContext<P = Record<string, any>> {
    asyncapi: AsyncAPIDocument;
    params: P;
    originalAsyncAPI: string;
    [key: string]: any;
}
/**
 * Signature for template function
 */
export declare type TemplateFunction<R = React.ReactElement | undefined> = (context: TemplateContext) => R | Promise<R>;
/**
 * Options for transpiling files.
 */
export declare type TranspileFilesOptions = {
    /**
     * Should all files in a directory including those in subdirectories be included
     */
    recursive?: boolean;
};
export declare type TemplateRenderMetadata = {
    fileName?: string;
    permissions?: string;
};
export declare type TemplateRenderResult = {
    metadata: TemplateRenderMetadata;
    content: string;
};
