"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStatsInDir = void 0;
var path_1 = __importDefault(require("path"));
var fs_1 = __importDefault(require("fs"));
var util_1 = require("util");
var _1 = require(".");
var readdir = util_1.promisify(fs_1.default.readdir);
var stat = util_1.promisify(fs_1.default.stat);
var GetFilesResponse = /** @class */ (function () {
    function GetFilesResponse(files, dirs) {
        this.files = files;
        this.dirs = dirs;
    }
    return GetFilesResponse;
}());
/**
 * Function which finds all the files and dirs in folders
 * @private
 * @param dir directory to find files and dirs in.
 * @param includeSubDirs should the function iterate through subdirectories to search for files and dirs?
 */
function getStatsInDir(dir) {
    return __awaiter(this, void 0, void 0, function () {
        var allFiles, files, dirs, _i, allFiles_1, filename, res, stats, resolveFilenameCallback;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, readdir(dir)];
                case 1:
                    allFiles = _a.sent();
                    files = [];
                    dirs = [];
                    _i = 0, allFiles_1 = allFiles;
                    _a.label = 2;
                case 2:
                    if (!(_i < allFiles_1.length)) return [3 /*break*/, 5];
                    filename = allFiles_1[_i];
                    res = path_1.default.resolve(dir, filename);
                    return [4 /*yield*/, stat(res)];
                case 3:
                    stats = _a.sent();
                    if (stats.isDirectory()) {
                        dirs.push(res);
                    }
                    else if (_1.isJsFile(filename)) {
                        files.push(res);
                    }
                    _a.label = 4;
                case 4:
                    _i++;
                    return [3 /*break*/, 2];
                case 5:
                    resolveFilenameCallback = function (filename) {
                        return path_1.default.resolve(dir, filename);
                    };
                    files = files.map(resolveFilenameCallback);
                    dirs = dirs.map(resolveFilenameCallback);
                    return [2 /*return*/, new GetFilesResponse(files, dirs)];
            }
        });
    });
}
exports.getStatsInDir = getStatsInDir;
//# sourceMappingURL=getStatsInDir.js.map