"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isJsFile = void 0;
var ALLOWED_EXTS = ['js', 'jsx', 'cjs'];
/**
 * Function which checks if file is JS file
 * @private
 * @param {string} filename
 * @returns {boolean}
 */
function isJsFile(filename) {
    if (filename === void 0) { filename = ''; }
    var ext = filename.split('.').pop() || '';
    return ALLOWED_EXTS.includes(ext);
}
exports.isJsFile = isJsFile;
//# sourceMappingURL=isJsFile.js.map