/**
 * Type of indentation to use
 * @readonly
 * @enum {string}
 * @property {string}  TABS   - indicate to use tabs as separator
 * @property {string}  SPACES - indicate to use spaces as separator
 */
export declare enum IndentationTypes {
    TABS = "tabs",
    SPACES = "spaces"
}
/**
 * Ensures indentations are prepended to content.
 * @private
 * @param {string} content to prepend the indentation
 * @param {number} size the number of indendations to use
 * @param {IndentationTypes} type the type of indendations to use. SPACES by default.
 * @returns {string}
 */
export declare function withIndendation(content: string | undefined, size: number, type?: IndentationTypes): string;
