"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withNewLines = void 0;
/**
 * Prepend given number of the new lines to content.
 * @private
 * @param {string} content
 * @param {number} number
 * @returns {string}
 */
function withNewLines(content, number) {
    if (content === void 0) { content = ''; }
    if (number === void 0) { number = 0; }
    var newLines = Array(number).fill('\n').join('');
    return content + newLines;
}
exports.withNewLines = withNewLines;
//# sourceMappingURL=withNewLines.js.map