const chai = require('chai');
const chaiAsPromised = require('chai-as-promised');
const fs = require('fs');
const path = require('path');
const openapiSchemaParser = require('..');
const parser = require('@asyncapi/parser');

chai.use(chaiAsPromised);
const expect = chai.expect;

const inputWithOpenAPI = fs.readFileSync(path.resolve(__dirname, './asyncapi-openapi.yaml'), 'utf8');
const outputWithOpenAPI = '{"asyncapi":"2.0.0","info":{"title":"My API","version":"1.0.0"},"channels":{"mychannel":{"publish":{"message":{"payload":{"type":["object","null"],"properties":{"name":{"type":"string","x-parser-schema-id":"<anonymous-schema-2>"},"discriminatorTest":{"discriminator":"objectType","oneOf":[{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-5>"},"prop1":{"type":"string","x-parser-schema-id":"<anonymous-schema-6>"}},"x-parser-schema-id":"<anonymous-schema-4>"},{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-8>"},"prop2":{"type":"string","x-parser-schema-id":"<anonymous-schema-9>"}},"x-parser-schema-id":"<anonymous-schema-7>"}],"x-parser-schema-id":"<anonymous-schema-3>"},"test":{"type":"object","properties":{"testing":{"type":"string","x-parser-schema-id":"<anonymous-schema-11>"}},"x-parser-schema-id":"<anonymous-schema-10>"}},"examples":[{"name":"Fran"}],"x-parser-schema-id":"<anonymous-schema-1>"},"x-parser-original-schema-format":"application/vnd.oai.openapi;version=3.0.0","x-parser-original-payload":{"type":"object","nullable":true,"example":{"name":"Fran"},"properties":{"name":{"type":"string","x-parser-schema-id":"<anonymous-schema-12>"},"discriminatorTest":{"discriminator":"objectType","oneOf":[{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-5>"},"prop1":{"type":"string","x-parser-schema-id":"<anonymous-schema-6>"}},"x-parser-schema-id":"<anonymous-schema-4>"},{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-8>"},"prop2":{"type":"string","x-parser-schema-id":"<anonymous-schema-9>"}},"x-parser-schema-id":"<anonymous-schema-7>"}],"x-parser-schema-id":"<anonymous-schema-13>"},"test":{"type":"object","properties":{"testing":{"type":"string","x-parser-schema-id":"<anonymous-schema-15>"}},"x-parser-schema-id":"<anonymous-schema-14>"}},"x-parser-schema-id":"testSchema"},"schemaFormat":"application/vnd.aai.asyncapi;version=2.0.0","x-parser-message-parsed":true,"x-parser-message-name":"testMessage"}}}},"components":{"messages":{"testMessage":{"payload":{"type":["object","null"],"properties":{"name":{"type":"string","x-parser-schema-id":"<anonymous-schema-2>"},"discriminatorTest":{"discriminator":"objectType","oneOf":[{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-5>"},"prop1":{"type":"string","x-parser-schema-id":"<anonymous-schema-6>"}},"x-parser-schema-id":"<anonymous-schema-4>"},{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-8>"},"prop2":{"type":"string","x-parser-schema-id":"<anonymous-schema-9>"}},"x-parser-schema-id":"<anonymous-schema-7>"}],"x-parser-schema-id":"<anonymous-schema-3>"},"test":{"type":"object","properties":{"testing":{"type":"string","x-parser-schema-id":"<anonymous-schema-11>"}},"x-parser-schema-id":"<anonymous-schema-10>"}},"examples":[{"name":"Fran"}],"x-parser-schema-id":"<anonymous-schema-1>"},"x-parser-original-schema-format":"application/vnd.oai.openapi;version=3.0.0","x-parser-original-payload":{"type":"object","nullable":true,"example":{"name":"Fran"},"properties":{"name":{"type":"string","x-parser-schema-id":"<anonymous-schema-12>"},"discriminatorTest":{"discriminator":"objectType","oneOf":[{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-5>"},"prop1":{"type":"string","x-parser-schema-id":"<anonymous-schema-6>"}},"x-parser-schema-id":"<anonymous-schema-4>"},{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-8>"},"prop2":{"type":"string","x-parser-schema-id":"<anonymous-schema-9>"}},"x-parser-schema-id":"<anonymous-schema-7>"}],"x-parser-schema-id":"<anonymous-schema-13>"},"test":{"type":"object","properties":{"testing":{"type":"string","x-parser-schema-id":"<anonymous-schema-15>"}},"x-parser-schema-id":"<anonymous-schema-14>"}},"x-parser-schema-id":"testSchema"},"schemaFormat":"application/vnd.aai.asyncapi;version=2.0.0","x-parser-message-parsed":true,"x-parser-message-name":"testMessage"}},"schemas":{"testSchema":{"type":"object","nullable":true,"example":{"name":"Fran"},"properties":{"name":{"type":"string","x-parser-schema-id":"<anonymous-schema-12>"},"discriminatorTest":{"discriminator":"objectType","oneOf":[{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-5>"},"prop1":{"type":"string","x-parser-schema-id":"<anonymous-schema-6>"}},"x-parser-schema-id":"<anonymous-schema-4>"},{"type":"object","properties":{"objectType":{"type":"string","x-parser-schema-id":"<anonymous-schema-8>"},"prop2":{"type":"string","x-parser-schema-id":"<anonymous-schema-9>"}},"x-parser-schema-id":"<anonymous-schema-7>"}],"x-parser-schema-id":"<anonymous-schema-13>"},"test":{"type":"object","properties":{"testing":{"type":"string","x-parser-schema-id":"<anonymous-schema-15>"}},"x-parser-schema-id":"<anonymous-schema-14>"}},"x-parser-schema-id":"testSchema"}}},"x-parser-spec-parsed":true}';

parser.registerSchemaParser(openapiSchemaParser);

describe('parse()', function() {
  it('should parse OpenAPI schemas', async function() {
    const result = await parser.parse(inputWithOpenAPI, { path: __filename });
    await expect(JSON.stringify(result.json())).to.equal(outputWithOpenAPI);
  });
});
