"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtoBuffSchemaParser = void 0;
const protoj2jsonSchema_1 = require("./protoj2jsonSchema");
function ProtoBuffSchemaParser() {
    return {
        validate,
        parse,
        getMimeTypes,
    };
}
exports.ProtoBuffSchemaParser = ProtoBuffSchemaParser;
exports.default = ProtoBuffSchemaParser;
function validate(input) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            (0, protoj2jsonSchema_1.proto2jsonSchema)(input.data);
            // No errors found.
            return [];
        }
        catch (error) {
            let message = 'Unknown Error';
            if (error instanceof Error) {
                message = error.message;
            }
            return [{
                    message,
                    path: input.path, // protobuf parser doesn't provide a path to the error.
                }];
        }
    });
}
function parse(input) {
    return (0, protoj2jsonSchema_1.proto2jsonSchema)(input.data);
}
function getMimeTypes() {
    return [
        'application/vnd.google.protobuf;version=2',
        'application/vnd.google.protobuf;version=3',
    ];
}
