"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.visit = void 0;
const protovalidate_1 = require("./protovalidate");
const OPTION_PREFIX = '(validate.rules)';
function visit(obj, field) {
    const parsedOption = findRootOption(field);
    if (parsedOption !== null) {
        (0, protovalidate_1.protocGenValidate)(parsedOption, obj);
    }
}
exports.visit = visit;
function findRootOption(field) {
    if (field.parsedOptions && field.parsedOptions[OPTION_PREFIX]) {
        return field.parsedOptions[OPTION_PREFIX];
    }
    else if (field.parsedOptions && Array.isArray(field.parsedOptions)) {
        for (const parsedOption of field.parsedOptions) {
            if (parsedOption[OPTION_PREFIX]) {
                return parsedOption[OPTION_PREFIX];
            }
        }
    }
    return null;
}
