import { protocGenValidate } from './protovalidate';
const OPTION_PREFIX = '(validate.rules)';
export function visit(obj, field) {
    const parsedOption = findRootOption(field);
    if (parsedOption !== null) {
        protocGenValidate(parsedOption, obj);
    }
}
function findRootOption(field) {
    if (field.parsedOptions && field.parsedOptions[OPTION_PREFIX]) {
        return field.parsedOptions[OPTION_PREFIX];
    }
    else if (field.parsedOptions && Array.isArray(field.parsedOptions)) {
        for (const parsedOption of field.parsedOptions) {
            if (parsedOption[OPTION_PREFIX]) {
                return parsedOption[OPTION_PREFIX];
            }
        }
    }
    return null;
}
