const chai = require('chai');
const chaiAsPromised = require('chai-as-promised');
const fs = require('fs');
const path = require('path');
const ramlDtParser = require('..');
const parser = require('@asyncapi/parser');

chai.use(chaiAsPromised);
const expect = chai.expect;

const inputWithRAML = fs.readFileSync(path.resolve(__dirname, './asyncapi-raml.yaml'), 'utf8');
const outputWithRAML = JSON.stringify({asyncapi: '2.0.0',info: {title: 'Example using RAML data types',version: '1.0.0'},channels: {mychannel: {publish: {message: {payload: {type: 'object',examples: [{title: 'A book',author: 'An author'}],additionalProperties: true,required: ['title','author'],properties: {title: {type: 'string','x-parser-schema-id': '<anonymous-schema-2>'},author: {type: 'string',examples: ['Eva'],'x-parser-schema-id': '<anonymous-schema-3>'}},'x-parser-schema-id': '<anonymous-schema-1>'},'x-parser-original-schema-format': 'application/raml+yaml;version=1.0','x-parser-original-payload': '#%RAML 1.0 Library\ntypes:\n  tmpType:\n    type: object\n    properties:\n      title: string\n      author:\n        type: string\n        examples:\n          anExample: Eva\n    examples:\n      exampleOne:\n        title: A book\n        author: An author\n',schemaFormat: 'application/vnd.aai.asyncapi;version=2.0.0','x-parser-message-parsed': true,'x-parser-message-name': 'testMessage'}}},otherchannel: {subscribe: {message: {payload: {minProperties: 1,maxProperties: 50,additionalProperties: false,discriminator: 'breed',discriminatorValue: 'CatOne',type: 'object',required: ['proscons','name','breed','age','rating','year_of_birth','time_of_birth','addition_date','removal_date','photo','description','character','siblings','parents','ratingHistory','additionalData'],properties: {proscons: {anyOf: [true,true],'x-parser-schema-id': '<anonymous-schema-5>'},name: true,breed: true,age: true,rating: {type: 'integer',multipleOf: 5,example: {displayName: 'Cat\'s rating',description: 'Rating of cat\'s awesomeness',strict: false,value: 50},'x-parser-schema-id': '<anonymous-schema-16>'},year_of_birth: {type: 'string',format: 'date','x-parser-schema-id': '<anonymous-schema-17>'},time_of_birth: {type: 'string',format: 'time','x-parser-schema-id': '<anonymous-schema-18>'},dt_of_birth: {type: 'string',format: 'date-time-only','x-parser-schema-id': '<anonymous-schema-19>'},addition_date: {type: 'string',format: 'rfc2616','x-parser-schema-id': '<anonymous-schema-20>'},removal_date: {type: 'string',format: 'date-time','x-parser-schema-id': '<anonymous-schema-21>'},photo: {type: 'string',minLength: 1,maxLength: 307200,'x-parser-schema-id': '<anonymous-schema-22>'},description: {type: 'null','x-parser-schema-id': '<anonymous-schema-23>'},habits: {type: 'string','x-parser-schema-id': '<anonymous-schema-24>'},character: {anyOf: [{type: 'null','x-parser-schema-id': '<anonymous-schema-26>'},{type: 'string','x-parser-schema-id': '<anonymous-schema-27>'}],'x-parser-schema-id': '<anonymous-schema-25>'},siblings: {type: 'array',items: {type: 'string','x-parser-schema-id': '<anonymous-schema-29>'},'x-parser-schema-id': '<anonymous-schema-28>'},parents: {type: 'array',items: true,'x-parser-schema-id': '<anonymous-schema-30>'},ratingHistory: {type: 'array',items: {anyOf: [{type: 'integer','x-parser-schema-id': '<anonymous-schema-35>'},{type: 'number','x-parser-schema-id': '<anonymous-schema-36>'}],'x-parser-schema-id': '<anonymous-schema-34>'},'x-parser-schema-id': '<anonymous-schema-33>'},additionalData: {type: 'object',additionalProperties: true,required: ['weight'],properties: {weight: {type: 'number','x-parser-schema-id': '<anonymous-schema-38>'}},'x-parser-schema-id': '<anonymous-schema-37>'}},'x-parser-schema-id': '<anonymous-schema-4>'},'x-parser-original-schema-format': 'application/raml+yaml;version=1.0','x-parser-original-payload': '#%RAML 1.0 Library\ntypes:\n  tmpType:\n    type:\n      - CatWithAddress\n      - CatWithCity\n    minProperties: 1\n    maxProperties: 50\n    additionalProperties: false\n    discriminator: breed\n    discriminatorValue: CatOne\n    properties:\n      proscons:\n        type: CatPros | CatCons\n        required: true\n      name:\n        type: CatName\n        amazing: true\n      breed:\n        type: CatBreed\n      age: CatAge\n      rating:\n        type: integer\n        multipleOf: 5\n        example:\n          displayName: Cat\'s rating\n          description: Rating of cat\'s awesomeness\n          strict: false\n          value: 50\n      year_of_birth: date-only\n      time_of_birth: time-only\n      dt_of_birth:\n        type: datetime-only\n        required: false\n      addition_date:\n        type: datetime\n        format: rfc2616\n      removal_date:\n        type: datetime\n      photo:\n        type: file\n        fileTypes:\n          - image/jpeg\n          - image/png\n        minLength: 1\n        maxLength: 307200\n      description: nil\n      habits?: string\n      character: nil | string\n      siblings: \'string[]\'\n      parents: \'CatName[]\'\n      ratingHistory: \'(integer | number)[]\'\n      additionalData:\n        type:\n          type: object\n          properties:\n            weight: number\n',schemaFormat: 'application/vnd.aai.asyncapi;version=2.0.0','x-parser-message-parsed': true,'x-parser-message-name': '<anonymous-message-2>'}}}},components: {messages: {testMessage: {payload: {type: 'object',examples: [{title: 'A book',author: 'An author'}],additionalProperties: true,required: ['title','author'],properties: {title: {type: 'string','x-parser-schema-id': '<anonymous-schema-2>'},author: {type: 'string',examples: ['Eva'],'x-parser-schema-id': '<anonymous-schema-3>'}},'x-parser-schema-id': '<anonymous-schema-1>'},'x-parser-original-schema-format': 'application/raml+yaml;version=1.0','x-parser-original-payload': '#%RAML 1.0 Library\ntypes:\n  tmpType:\n    type: object\n    properties:\n      title: string\n      author:\n        type: string\n        examples:\n          anExample: Eva\n    examples:\n      exampleOne:\n        title: A book\n        author: An author\n',schemaFormat: 'application/vnd.aai.asyncapi;version=2.0.0','x-parser-message-parsed': true,'x-parser-message-name': 'testMessage'}}}, 'x-parser-spec-parsed': true});

parser.registerSchemaParser(ramlDtParser);

describe('parse()', function() {
  it('should parse RAML data types', async function() {
    const result = await parser.parse(inputWithRAML, { path: __filename });
    await expect(JSON.stringify(result.json())).to.equal(outputWithRAML);
  });
});
