import React from 'react';
import { bemClasses } from '../helpers';
import { DEPRECATED_TEXT, PUBLISH_TEXT, SUBSCRIBE_TEXT, REQUIRED_TEXT, GENERATED_TEXT, } from '../constants';
export var BadgeType;
(function (BadgeType) {
    BadgeType["DEPRECATED"] = "deprecated";
    BadgeType["PUBLISH"] = "publish";
    BadgeType["SUBSCRIBE"] = "subscribe";
    BadgeType["REQUIRED"] = "required";
    BadgeType["GENERATED"] = "generated";
})(BadgeType || (BadgeType = {}));
export var Badge = function (_a) {
    var _b = _a.type, type = _b === void 0 ? '' : _b;
    var element = function (t, text) { return (React.createElement("span", { className: bemClasses.element("badge") + " " + bemClasses.modifier(t, "badge") }, text)); };
    switch (type) {
        case BadgeType.DEPRECATED: {
            return element(BadgeType.DEPRECATED, DEPRECATED_TEXT);
        }
        case BadgeType.PUBLISH: {
            return element(BadgeType.PUBLISH, PUBLISH_TEXT);
        }
        case BadgeType.SUBSCRIBE: {
            return element(BadgeType.SUBSCRIBE, SUBSCRIBE_TEXT);
        }
        case BadgeType.REQUIRED: {
            return element(BadgeType.REQUIRED, REQUIRED_TEXT);
        }
        case BadgeType.GENERATED: {
            return element(BadgeType.GENERATED, GENERATED_TEXT);
        }
        default: {
            return null;
        }
    }
};
//# sourceMappingURL=Badge.js.map