import React, { useState, useEffect } from 'react';
import { bemClasses } from '../helpers';
import { COLLAPSE_ALL_TEXT, EXPAND_ALL_TEXT } from '../constants';
import { useExpandedContext } from '../store';
export var CollapseButton = function () {
    var _a = useExpandedContext(), expanded = _a.expanded, setExpanded = _a.setExpanded, numberOfElements = _a.numberOfElements, numberOfExpanded = _a.numberOfExpanded;
    var _b = useState(false), initial = _b[0], setInitial = _b[1];
    useEffect(function () {
        setInitial(true);
    }, []);
    useEffect(function () {
        if (!initial) {
            return;
        }
        if (numberOfExpanded === 0 && expanded) {
            setExpanded(false);
        }
        if (numberOfExpanded === numberOfElements && !expanded) {
            setExpanded(true);
        }
    }, [numberOfExpanded]);
    return (React.createElement("button", { className: bemClasses.element("collapse-button"), onClick: function () { return setExpanded(function (state) { return !state; }); } },
        React.createElement("span", null, expanded ? COLLAPSE_ALL_TEXT : EXPAND_ALL_TEXT)));
};
//# sourceMappingURL=CollapseButton.js.map