var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import { TableHeader } from './TableHeader';
import { TableRow } from './TableRow';
import { createNestedClassName } from '../helpers';
export var Table = function (_a) {
    var header = _a.header, _b = _a.rows, rows = _b === void 0 ? [] : _b, _c = _a.accessors, accessors = _c === void 0 ? [] : _c, _d = _a.nested, nested = _d === void 0 ? false : _d, children = _a.children;
    if (!children && !rows.length) {
        return null;
    }
    var tableClassName = createNestedClassName("table", nested);
    var tableBodyClassName = createNestedClassName("table-body", nested);
    return (React.createElement("table", { className: tableClassName },
        React.createElement(TableHeader, __assign({}, header, { nested: header.nested || nested })),
        React.createElement("tbody", { className: tableBodyClassName }, children
            ? children
            : rows.map(function (row, index) { return (React.createElement(TableRow, __assign({}, row, { key: index, accessors: row.accessors || accessors, nested: row.nested || nested }))); }))));
};
//# sourceMappingURL=Table.js.map