import React from 'react';
import { bemClasses, createNestedClassName } from '../helpers';
export var TableRow = function (_a) {
    var element = _a.element, _b = _a.rootKey, rootKey = _b === void 0 ? '' : _b, _c = _a.accessors, accessors = _c === void 0 ? [] : _c, _d = _a.nested, nested = _d === void 0 ? false : _d, _e = _a.className, className = _e === void 0 ? '' : _e;
    var renderRowByAccessors = function (acs, el, nest) {
        return acs.map(function (accessor, index) { return (React.createElement("td", { key: index, className: createNestedClassName("table-cell", nest) }, resolveAccessor(accessor, el))); });
    };
    var resolveAccessor = function (accessor, el) {
        if (accessor instanceof Function) {
            return accessor(el);
        }
        var value = el[accessor];
        if (typeof value === 'boolean' || typeof value === 'number') {
            return value.toString();
        }
        return value;
    };
    var content = accessors && accessors.length
        ? renderRowByAccessors(accessors, element, nested)
        : element;
    var nestedClassName = createNestedClassName("table-row", nested);
    return (React.createElement("tr", { key: rootKey, className: bemClasses.concatenate([nestedClassName, className]) }, content));
};
//# sourceMappingURL=TableRow.js.map