import React, { useState, useEffect } from 'react';
import { useExpandedContext } from '../store';
import { bemClasses, inContainer } from '../helpers';
import { CONTAINER_LABELS_VALUES, ITEM_LABELS_VALUES, } from '../constants';
export var Toggle = function (_a) {
    var header = _a.header, _b = _a.className, customClassName = _b === void 0 ? '' : _b, _c = _a.expanded, initialExpanded = _c === void 0 ? false : _c, _d = _a.toggleInState, toggleInState = _d === void 0 ? false : _d, _e = _a.label, label = _e === void 0 ? '' : _e, _f = _a.itemName, itemName = _f === void 0 ? '' : _f, children = _a.children;
    var _g = useExpandedContext(), globalExpanded = _g.expanded, setNumberOfExpanded = _g.setNumberOfExpanded, clickedItem = _g.clickedItem, setClickedItem = _g.setClickedItem, setScrollToView = _g.setScrollToView;
    var _h = useState(false), initial = _h[0], setInitial = _h[1];
    var _j = useState(initialExpanded), expanded = _j[0], setExpanded = _j[1];
    var handleSetExpanded = function (e) {
        e.stopPropagation();
        var newState = !expanded;
        if (children) {
            setExpanded(newState);
        }
        setClickedItem({
            label: label,
            itemName: itemName,
            state: newState,
            scroll: false,
        });
    };
    useEffect(function () {
        setInitial(true);
    }, []);
    useEffect(function () {
        if (clickedItem &&
            clickedItem.scroll &&
            clickedItem.state &&
            clickedItem.label === label) {
            setScrollToView(function (state) { return !state; });
        }
    }, [expanded]);
    useEffect(function () {
        if (initial && toggleInState) {
            setExpanded(globalExpanded);
        }
    }, [globalExpanded]);
    useEffect(function () {
        if (!initial) {
            return;
        }
        if (!(clickedItem && clickedItem.state) &&
            ITEM_LABELS_VALUES.includes(label) &&
            clickedItem.label === inContainer(label)) {
            setExpanded(false);
            return;
        }
        if (!expanded && clickedItem && clickedItem.state && label) {
            if (clickedItem.label === label &&
                CONTAINER_LABELS_VALUES.includes(label)) {
                setExpanded(true);
                return;
            }
            if (clickedItem.label === inContainer(label) &&
                itemName &&
                clickedItem.itemName === itemName) {
                setExpanded(true);
                return;
            }
        }
    }, [initial, clickedItem]);
    useEffect(function () {
        if (toggleInState && initial) {
            setNumberOfExpanded(function (state) { return (expanded ? state + 1 : state - 1); });
        }
    }, [expanded, setNumberOfExpanded]);
    var className = "toggle";
    var classes = bemClasses.concatenate([
        bemClasses.element(className),
        expanded ? bemClasses.modifier("expanded", className) : '',
        bemClasses.element(customClassName + "-toggle"),
        !children ? bemClasses.modifier("no-children", className) : '',
        !children ? bemClasses.modifier("no-children", customClassName) : '',
        expanded
            ? bemClasses.modifier("expanded", customClassName + "-toggle")
            : '',
    ]);
    var headerClasses = bemClasses.concatenate([
        bemClasses.element(className + "-header"),
        bemClasses.element(customClassName + "-header"),
    ]);
    var arrowClasses = bemClasses.concatenate([
        bemClasses.element(className + "-arrow"),
        expanded ? bemClasses.modifier("expanded", className + "-arrow") : '',
    ]);
    var bodyClasses = bemClasses.concatenate([
        bemClasses.element(className + "-body"),
        bemClasses.element(customClassName + "-body"),
    ]);
    return (React.createElement("div", { className: classes, onClick: function (e) {
            if (!expanded) {
                handleSetExpanded(e);
            }
        } },
        React.createElement("header", { className: headerClasses, onClick: handleSetExpanded },
            React.createElement("div", { className: bemClasses.element(className + "-header-content") }, header),
            children && (React.createElement("button", { className: bemClasses.element(className + "-button") },
                React.createElement("span", { className: arrowClasses })))),
        children && React.createElement("div", { className: bodyClasses }, children)));
};
//# sourceMappingURL=Toggle.js.map