var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import React, { Component } from 'react';
import { isFetchingSchemaInterface, } from '../../types';
import { defaultConfig } from '../../config';
import { beautifier, bemClasses, stateHelpers, Parser } from '../../helpers';
import { CSS_PREFIX } from '../../constants';
import { useExpandedContext, useChangeHashContext } from '../../store';
import { ErrorComponent } from '../Error/Error';
import { InfoComponent } from '../Info/Info';
import { ChannelsComponent } from '../Channels/Channels';
import { ServersComponent } from '../Servers/Servers';
import { MessagesComponent } from '../Messages/Messages';
import { SchemasComponent } from '../Schemas/Schemas';
var defaultAsyncApi = {
    asyncapi: '2.0.0-rc2',
    info: {
        title: 'AsyncApi example title',
        version: '1.0.0',
    },
    channels: {},
};
var AsyncApiComponent = (function (_super) {
    __extends(AsyncApiComponent, _super);
    function AsyncApiComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            validatedSchema: defaultAsyncApi,
            error: undefined,
        };
        _this.parser = new Parser();
        return _this;
    }
    AsyncApiComponent.prototype.componentDidMount = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.parseSchema(this.props.schema, this.props.config && this.props.config.parserOptions);
                return [2];
            });
        });
    };
    AsyncApiComponent.prototype.componentDidUpdate = function (prevProps) {
        return __awaiter(this, void 0, void 0, function () {
            var schema;
            return __generator(this, function (_a) {
                schema = prevProps.schema;
                if (schema !== this.props.schema) {
                    this.parseSchema(this.props.schema, this.props.config && this.props.config.parserOptions);
                }
                return [2];
            });
        });
    };
    AsyncApiComponent.prototype.render = function () {
        var config = this.props.config;
        var _a = this.state, validatedSchema = _a.validatedSchema, error = _a.error;
        var concatenatedConfig = __assign(__assign(__assign({}, defaultConfig), config), { show: __assign(__assign({}, defaultConfig.show), (!!config && config.show)), expand: __assign(__assign({}, defaultConfig.expand), (!!config && config.expand)) });
        if (!validatedSchema || !Object.keys(validatedSchema).length) {
            if (!error) {
                return null;
            }
            return concatenatedConfig.showErrors && React.createElement(ErrorComponent, { error: error });
        }
        if (!concatenatedConfig.show) {
            return null;
        }
        bemClasses.setSchemaID(concatenatedConfig.schemaID);
        var numberOfElement = stateHelpers.calculateNumberOfElements({
            spec: validatedSchema,
            showConfig: concatenatedConfig.show,
        });
        var initialExpandedElements = stateHelpers.calculateInitialExpandedElements({
            spec: validatedSchema,
            showConfig: concatenatedConfig.show,
            expandConfig: concatenatedConfig.expand || {},
        });
        return (React.createElement(useExpandedContext.Provider, { numberOfElements: numberOfElement, numberOfExpandedElement: initialExpandedElements },
            React.createElement(useChangeHashContext.Provider, { schemaName: bemClasses.getSchemaID() },
                React.createElement("main", { className: CSS_PREFIX, id: bemClasses.getSchemaID() },
                    concatenatedConfig.showErrors && !!error && (React.createElement(ErrorComponent, { error: error })),
                    concatenatedConfig.show.info && validatedSchema.info && (React.createElement(InfoComponent, { info: validatedSchema.info, defaultContentType: validatedSchema.defaultContentType })),
                    concatenatedConfig.show.channels && validatedSchema.channels && (React.createElement(ChannelsComponent, { channels: validatedSchema.channels, expand: concatenatedConfig.expand &&
                            concatenatedConfig.expand.channels })),
                    concatenatedConfig.show.servers && !!validatedSchema.servers && (React.createElement(ServersComponent, { servers: validatedSchema.servers, securitySchemes: validatedSchema.components &&
                            validatedSchema.components.securitySchemes, expand: concatenatedConfig.expand && concatenatedConfig.expand.servers })),
                    validatedSchema.components && (React.createElement("section", { className: bemClasses.element("components") },
                        concatenatedConfig.show.messages &&
                            validatedSchema.components.messages && (React.createElement(MessagesComponent, { messages: validatedSchema.components.messages, expand: concatenatedConfig.expand &&
                                concatenatedConfig.expand.messages })),
                        concatenatedConfig.show.schemas &&
                            validatedSchema.components.schemas && (React.createElement(SchemasComponent, { schemas: validatedSchema.components.schemas, expand: concatenatedConfig.expand &&
                                concatenatedConfig.expand.schemas }))))))));
    };
    AsyncApiComponent.prototype.parseSchema = function (schema, parserOptions) {
        return __awaiter(this, void 0, void 0, function () {
            var parsedFromUrl, parsed;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!isFetchingSchemaInterface(schema)) return [3, 2];
                        return [4, this.parser.parseFromUrl(schema, parserOptions)];
                    case 1:
                        parsedFromUrl = _a.sent();
                        this.setState({
                            validatedSchema: this.beautifySchema(parsedFromUrl.data),
                            error: parsedFromUrl.error,
                        });
                        return [2];
                    case 2: return [4, this.parser.parse(schema, parserOptions)];
                    case 3:
                        parsed = _a.sent();
                        this.setState({
                            validatedSchema: this.beautifySchema(parsed.data),
                            error: parsed.error,
                        });
                        return [2];
                }
            });
        });
    };
    AsyncApiComponent.prototype.beautifySchema = function (schema) {
        if (!schema) {
            return null;
        }
        return beautifier.beautify(schema);
    };
    return AsyncApiComponent;
}(Component));
export default AsyncApiComponent;
//# sourceMappingURL=AsyncApi.js.map