import React from 'react';
import { bemClasses, bindingsHelper } from '../../helpers';
import { SchemaComponent } from '../Schemas/Schema';
import { BINDINGS_SCHEMA_OBJECT_TEXT } from '../../constants';
var className = "binding-field";
export var BindingFieldComponent = function (_a) {
    var value = _a.value, context = _a.context, bindingType = _a.bindingType;
    if (value === null || value === undefined) {
        return null;
    }
    var isObject = bindingsHelper.isObject(value);
    var isSchemaObject = bindingsHelper.isSchemaObject(context, bindingType);
    if (isSchemaObject && isObject) {
        return (React.createElement(React.Fragment, null,
            React.createElement("div", { className: "flex py-2" },
                React.createElement("div", { className: "flex-1" },
                    React.createElement("div", { className: bemClasses.element(className + "-name") }, context)),
                React.createElement("div", { className: "flex-1" }, BINDINGS_SCHEMA_OBJECT_TEXT)),
            React.createElement("div", { className: bemClasses.element(className + "-schema") },
                React.createElement(SchemaComponent, { name: context, schema: value, hideTitle: true }))));
    }
    if (isObject) {
        return (React.createElement(React.Fragment, null, Object.entries(value).map(function (_a) {
            var key = _a[0], val = _a[1];
            return (React.createElement(BindingFieldComponent, { value: val, context: context + "." + key, bindingType: bindingType, key: key }));
        })));
    }
    return (React.createElement("div", null,
        React.createElement("div", { className: "flex py-2" },
            React.createElement("div", { className: "flex-1" },
                React.createElement("div", { className: bemClasses.element(className + "-name") }, context)),
            React.createElement("div", { className: "flex-1" }, typeof value === 'boolean' ? JSON.stringify(value) : value))));
};
//# sourceMappingURL=BindingField.js.map