import React from 'react';
import { bemClasses } from '../../helpers';
import { BindingComponent } from './Binding';
var className = "bindings";
export var BindingsComponent = function (_a) {
    var bindings = _a.bindings, title = _a.title;
    if (!bindings || Object.keys(bindings).length === 0) {
        return null;
    }
    var content = (React.createElement("div", { className: bemClasses.element(className + "-table") + " p-4" }, Object.entries(bindings).map(function (_a) {
        var name = _a[0], binding = _a[1];
        return (React.createElement(BindingComponent, { name: name, binding: binding, key: name }));
    })));
    return (React.createElement("section", { className: bemClasses.element(className) },
        React.createElement("div", { className: bemClasses.element(className + "-header") },
            React.createElement("h4", null, title),
            React.createElement("div", { className: bemClasses.element(className + "-description") }, content))));
};
//# sourceMappingURL=Bindings.js.map