import React from 'react';
import { OperationComponent } from './Operation';
import { Parameters as ParametersComponent } from './Parameters';
import { BindingsComponent } from '../Bindings/Bindings';
import { Badge, BadgeType, Markdown, Toggle } from '../../components';
import { bemClasses, removeSpecialChars } from '../../helpers';
import { ITEM_LABELS, CONTAINER_LABELS, CHANNEL_BINDINGS_TEXT, } from '../../constants';
import { isRawMessage, PayloadType } from '../../types';
export var ChannelComponent = function (_a) {
    var name = _a.name, channel = _a.channel, _b = _a.toggleExpand, toggleExpand = _b === void 0 ? false : _b;
    var className = ITEM_LABELS.CHANNEL;
    var identifier = bemClasses.identifier([CONTAINER_LABELS.CHANNELS, name]);
    var dataIdentifier = bemClasses.identifier([
        CONTAINER_LABELS.CHANNELS,
        removeSpecialChars(name),
    ]);
    var oneOfPublish = channel.publish &&
        channel.publish.message &&
        !isRawMessage(channel.publish.message);
    var oneOfSubscribe = channel.subscribe &&
        channel.subscribe.message &&
        !isRawMessage(channel.subscribe.message);
    var header = (React.createElement("h3", null,
        React.createElement("ul", { className: bemClasses.element(className + "-header-badges") },
            channel.deprecated && (React.createElement("li", { className: bemClasses.element(className + "-header-badges-deprecated-badge") },
                React.createElement(Badge, { type: BadgeType.DEPRECATED }))),
            channel.publish && (React.createElement("li", { className: bemClasses.element(className + "-header-publish-badge") },
                React.createElement(Badge, { type: BadgeType.PUBLISH }))),
            channel.subscribe && (React.createElement("li", { className: bemClasses.element(className + "-header-subscribe-badge") },
                React.createElement(Badge, { type: BadgeType.SUBSCRIBE })))),
        React.createElement("span", { className: bemClasses.element(className + "-header-title") }, name)));
    var content = (React.createElement(React.Fragment, null,
        channel.description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
            React.createElement(Markdown, null, channel.description))),
        React.createElement(ParametersComponent, { parameters: channel.parameters, identifier: bemClasses.identifier([
                { id: identifier, toKebabCase: false },
                'parameters',
            ]), dataIdentifier: bemClasses.identifier([
                { id: dataIdentifier, toKebabCase: false },
                'parameters',
            ]) }),
        channel.bindings && (React.createElement(BindingsComponent, { bindings: channel.bindings, title: CHANNEL_BINDINGS_TEXT })),
        React.createElement("div", { className: bemClasses.element(className + "-operations") },
            React.createElement("ul", { className: bemClasses.element(className + "-operations-list") },
                channel.subscribe && (React.createElement("li", { className: bemClasses.element(className + "-operations-subscribe") },
                    React.createElement(OperationComponent, { payloadType: PayloadType.SUBSCRIBE, operation: channel.subscribe, oneOf: oneOfSubscribe, otherOneOf: oneOfPublish, isPublish: !!channel.publish, isSubscribe: !!channel.subscribe }))),
                channel.publish && (React.createElement("li", { className: bemClasses.element(className + "-operations-publish") },
                    React.createElement(OperationComponent, { payloadType: PayloadType.PUBLISH, operation: channel.publish, otherOneOf: oneOfSubscribe, oneOf: oneOfPublish, isPublish: !!channel.publish, isSubscribe: !!channel.subscribe })))))));
    var body = (channel.subscribe || channel.publish) && content;
    return (React.createElement("section", { className: bemClasses.element(className), id: identifier, "data-asyncapi-id": dataIdentifier },
        React.createElement(Toggle, { header: header, className: className, expanded: toggleExpand, label: ITEM_LABELS.CHANNEL, itemName: name, toggleInState: true }, body)));
};
//# sourceMappingURL=Channel.js.map