import React from 'react';
import { ChannelComponent } from './Channel';
import { bemClasses } from '../../helpers';
import { Toggle } from '../../components';
import { CHANNELS_TEXT, CONTAINER_LABELS } from '../../constants';
export var ChannelsComponent = function (_a) {
    var channels = _a.channels, expand = _a.expand;
    var className = CONTAINER_LABELS.CHANNELS;
    var header = React.createElement("h2", null, CHANNELS_TEXT);
    var content = (React.createElement("ul", { className: bemClasses.element(className + "-list") }, Object.entries(channels).map(function (_a) {
        var name = _a[0], channel = _a[1];
        return (React.createElement("li", { key: name, className: bemClasses.element(className + "-list-item") },
            React.createElement(ChannelComponent, { name: name, channel: channel, toggleExpand: expand && expand.elements })));
    })));
    return (React.createElement("section", { className: bemClasses.element(className), id: bemClasses.identifier([className]) },
        React.createElement(Toggle, { header: header, className: className, expanded: expand && expand.root, label: CONTAINER_LABELS.CHANNELS, toggleInState: true }, content)));
};
//# sourceMappingURL=Channels.js.map