import React from 'react';
import { MessagesComponent } from '../Messages/Messages';
import { MessageComponent } from '../Messages/Message';
import { BindingsComponent } from '../Bindings/Bindings';
import { bemClasses } from '../../helpers';
import { Badge, BadgeType, Markdown } from '../../components';
import { PayloadType, isRawMessage } from '../../types';
import { ONE_OF_FOLLOWING_MESSAGES_PUBLISH_TEXT, ONE_OF_FOLLOWING_MESSAGES_SUBSCRIBE_TEXT, RAW_MESSAGE_PUBLISH_TEXT, RAW_MESSAGE_SUBSCRIBE_TEXT, OPERATION_BINDINGS_TEXT, } from '../../constants';
export var OperationComponent = function (_a) {
    var _b = _a.payloadType, payloadType = _b === void 0 ? PayloadType.PUBLISH : _b, operation = _a.operation, _c = _a.oneOf, oneOf = _c === void 0 ? false : _c, _d = _a.otherOneOf, otherOneOf = _d === void 0 ? false : _d, _e = _a.isPublish, isPublish = _e === void 0 ? false : _e, _f = _a.isSubscribe, isSubscribe = _f === void 0 ? false : _f;
    if (!operation || !operation.message) {
        return null;
    }
    var className = "channel-operation";
    var messages = {};
    if (oneOf && !isRawMessage(operation.message)) {
        messages = operation.message.oneOf
            .map(function (message, index) {
            var _a;
            return (_a = {}, _a[index.toString()] = message, _a);
        })
            .reduce(function (obj, item) { return Object.assign(obj, item); }, {});
    }
    if (!oneOf && otherOneOf) {
        messages = {
            0: operation.message,
        };
    }
    if (oneOf || otherOneOf) {
        return (React.createElement("section", { className: bemClasses.element(className + "-oneOf-" + payloadType) },
            React.createElement("header", { className: bemClasses.element(className + "-oneOf-" + payloadType + "-header") },
                React.createElement("h4", null,
                    isPublish && isSubscribe ? (React.createElement(Badge, { type: payloadType === PayloadType.PUBLISH
                            ? BadgeType.PUBLISH
                            : BadgeType.SUBSCRIBE })) : null,
                    React.createElement("span", null, payloadType === PayloadType.PUBLISH
                        ? ONE_OF_FOLLOWING_MESSAGES_PUBLISH_TEXT
                        : ONE_OF_FOLLOWING_MESSAGES_SUBSCRIBE_TEXT))),
            operation.summary && (React.createElement("div", { className: bemClasses.element(className + "-description") },
                React.createElement(Markdown, null, operation.summary))),
            operation.description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
                React.createElement(Markdown, null, operation.description))),
            operation.bindings && (React.createElement(BindingsComponent, { bindings: operation.bindings, title: OPERATION_BINDINGS_TEXT })),
            React.createElement(MessagesComponent, { messages: messages, inChannel: true })));
    }
    var operationTitle = operation.summary
        ? operation.summary
        : payloadType === PayloadType.PUBLISH
            ? RAW_MESSAGE_PUBLISH_TEXT
            : RAW_MESSAGE_SUBSCRIBE_TEXT;
    return (React.createElement("section", { className: bemClasses.element(className + "-message") },
        React.createElement("header", { className: bemClasses.element(className + "-message-header") },
            React.createElement("h4", null,
                isPublish && isSubscribe ? (React.createElement(Badge, { type: payloadType === PayloadType.PUBLISH
                        ? BadgeType.PUBLISH
                        : BadgeType.SUBSCRIBE })) : null,
                operationTitle)),
        operation.description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
            React.createElement(Markdown, null, operation.description))),
        operation.bindings && (React.createElement(BindingsComponent, { bindings: operation.bindings, title: OPERATION_BINDINGS_TEXT })),
        React.createElement(MessageComponent, { message: operation.message, inChannel: true })));
};
//# sourceMappingURL=Operation.js.map