import React from 'react';
import { Parameter } from './Parameter';
import { bemClasses } from '../../helpers';
import { PARAMETERS_TEXT } from '../../constants';
export var Parameters = function (_a) {
    var parameters = _a.parameters, identifier = _a.identifier, dataIdentifier = _a.dataIdentifier;
    if (!parameters) {
        return null;
    }
    return (React.createElement("div", { className: bemClasses.element("channel-parameters"), id: identifier, "data-asyncapi-id": dataIdentifier },
        React.createElement("header", { className: bemClasses.element("channel-parameters-header") },
            React.createElement("h4", null, PARAMETERS_TEXT)),
        React.createElement("ul", { className: bemClasses.element("channel-parameters-list") }, Object.entries(parameters).map(function (_a) {
            var name = _a[0], param = _a[1];
            return (React.createElement("li", { key: name, className: bemClasses.element("channel-parameters-list-item") },
                React.createElement(Parameter, { param: param, name: name })));
        }))));
};
//# sourceMappingURL=Parameters.js.map