import React from 'react';
import { bemClasses } from '../../helpers';
import { Toggle } from '../../components';
import { ERROR_TEXT } from '../../constants';
var renderErrors = function (errors) {
    if (!errors) {
        return null;
    }
    return errors
        .map(function (singleError, index) {
        var formattedError = formatError(singleError);
        if (!formattedError) {
            return null;
        }
        return (React.createElement("div", { key: index },
            React.createElement("code", { className: bemClasses.element("error-content-code"), key: index }, formattedError)));
    })
        .filter(Boolean);
};
export var formatError = function (singleError) {
    return singleError.title;
};
export var ErrorComponent = function (_a) {
    var error = _a.error;
    if (!error) {
        return null;
    }
    var className = "error";
    var title = error.title, validationErrors = error.validationErrors;
    var header = (React.createElement("h2", null,
        ERROR_TEXT,
        ": ",
        title));
    return (React.createElement("section", { className: bemClasses.element(className) },
        React.createElement(Toggle, { header: header, className: className }, validationErrors && validationErrors.length && (React.createElement("div", { className: bemClasses.element(className + "-body") },
            React.createElement("pre", { className: bemClasses.element(className + "-body-pre") }, renderErrors(validationErrors)))))));
};
//# sourceMappingURL=Error.js.map