import React from 'react';
import { Href } from '../../components';
import { bemClasses } from '../../helpers';
import { URL_SUPPORT_TEXT, EMAIL_SUPPORT_TEXT } from '../../constants';
export var ContactComponent = function (_a) {
    var url = _a.url, email = _a.email;
    return (React.createElement(React.Fragment, null,
        url && (React.createElement("li", { className: bemClasses.element("info-contact-support-url") },
            React.createElement(Href, { href: url },
                React.createElement("span", null, URL_SUPPORT_TEXT)))),
        email && (React.createElement("li", { className: bemClasses.element("info-contact-support-email") },
            React.createElement(Href, { href: "mailto:" + email },
                React.createElement("span", null, EMAIL_SUPPORT_TEXT))))));
};
//# sourceMappingURL=Contact.js.map