var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import { TermsOfServiceComponent } from './TermsOfService';
import { LicenseComponent } from './License';
import { ContactComponent } from './Contact';
import { DefaultContentTypeComponent } from './DefaultContentType';
import { Markdown, CollapseButton } from '../../components';
import { bemClasses } from '../../helpers';
export var InfoComponent = function (_a) {
    var _b = _a.info, title = _b.title, version = _b.version, description = _b.description, termsOfService = _b.termsOfService, contact = _b.contact, license = _b.license, defaultContentType = _a.defaultContentType;
    var className = "info";
    var showInfoList = defaultContentType || termsOfService || license || contact;
    return (React.createElement("section", { className: bemClasses.element(className), id: bemClasses.identifier([className]) },
        React.createElement("header", { className: bemClasses.element(className + "-header") },
            React.createElement("div", { className: bemClasses.element(className + "-header-main") },
                React.createElement("h1", null,
                    React.createElement("span", { className: bemClasses.element(className + "-header-title") }, title),
                    version && (React.createElement("span", { className: bemClasses.element(className + "-header-version") }, version))),
                React.createElement(CollapseButton, null)),
            !showInfoList ? null : (React.createElement("ul", { className: bemClasses.element(className + "-list") },
                defaultContentType && (React.createElement("li", { className: bemClasses.element(className + "-default-content-type") },
                    React.createElement(DefaultContentTypeComponent, { type: defaultContentType }))),
                termsOfService && (React.createElement("li", { className: bemClasses.element(className + "-terms-of-service") },
                    React.createElement(TermsOfServiceComponent, { url: termsOfService }))),
                license && (React.createElement("li", { className: bemClasses.element(className + "-license") },
                    React.createElement(LicenseComponent, __assign({}, license)))),
                contact && (contact.url || contact.email) ? (React.createElement(ContactComponent, __assign({}, contact))) : null))),
        description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
            React.createElement(Markdown, null, description)))));
};
//# sourceMappingURL=Info.js.map