import React from 'react';
import { SchemaComponent } from '../Schemas/Schema';
import { PayloadComponent } from './Payload';
import { BindingsComponent } from '../Bindings/Bindings';
import { bemClasses, removeSpecialChars, getExamplesFromSpec, } from '../../helpers';
import { isRawMessage } from '../../types';
import { Markdown, Badge, BadgeType, Toggle } from '../../components';
import { DEPRECATED_TEXT, HEADERS_TEXT, MESSAGE_HEADERS_TEXT, HEADERS_EXAMPLE_TEXT, CONTAINER_LABELS, ITEM_LABELS, MESSAGE_BINDINGS_TEXT, } from '../../constants';
export var MessageComponent = function (_a) {
    var title = _a.title, message = _a.message, hideTags = _a.hideTags, _b = _a.inChannel, inChannel = _b === void 0 ? false : _b, _c = _a.toggleExpand, toggleExpand = _c === void 0 ? false : _c, _d = _a.oneOf, oneOf = _d === void 0 ? false : _d;
    if (!message) {
        return null;
    }
    var className = ITEM_LABELS.MESSAGE;
    var messageID = title && title.length
        ? bemClasses.identifier([CONTAINER_LABELS.MESSAGES, title])
        : bemClasses.identifier([CONTAINER_LABELS.MESSAGES]);
    var messageDataID = title && title.length
        ? bemClasses.identifier([
            CONTAINER_LABELS.MESSAGES,
            removeSpecialChars(title),
        ])
        : bemClasses.identifier([CONTAINER_LABELS.MESSAGES]);
    if (!isRawMessage(message)) {
        return (React.createElement("ul", { className: bemClasses.element(className + "-raw-list") }, message.oneOf.map(function (elem, index) { return (React.createElement("li", { key: index, className: bemClasses.element(className + "-raw-list-item") },
            React.createElement(MessageComponent, { message: elem, key: index, title: elem.title, inChannel: inChannel, oneOf: true }))); })));
    }
    title = title || message.title || message.name;
    var examples = message.examples;
    var summary = message.summary && (React.createElement("div", { className: bemClasses.element(className + "-summary") },
        React.createElement(Markdown, null, message.summary)));
    var description = message.description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
        React.createElement(Markdown, null, message.description)));
    var header = !(title || summary) ? null : (React.createElement("section", { className: bemClasses.element(className + "-header") },
        message.deprecated && (React.createElement("div", { className: bemClasses.element(className + "-header-deprecated-badge") },
            React.createElement(Badge, { type: BadgeType.DEPRECATED }, DEPRECATED_TEXT))),
        title ? (React.createElement("header", { className: bemClasses.element(className + "-header-title") },
            React.createElement("h3", null, title))) : null));
    var headersID = !inChannel
        ? bemClasses.identifier([{ id: messageID, toKebabCase: false }, 'headers'])
        : undefined;
    var headers = message.headers && (React.createElement("section", { className: bemClasses.element(className + "-headers"), id: headersID, "data-asyncapi-id": headersID },
        React.createElement("header", { className: bemClasses.element(className + "-headers-header") },
            React.createElement("h4", null, HEADERS_TEXT)),
        React.createElement("div", { className: bemClasses.element(className + "-headers-schema") },
            React.createElement(SchemaComponent, { name: MESSAGE_HEADERS_TEXT, schema: message.headers, exampleTitle: HEADERS_EXAMPLE_TEXT, hideTitle: true, examples: examples && getExamplesFromSpec(examples, 'headers') }))));
    var payloadID = !inChannel
        ? bemClasses.identifier([{ id: messageID, toKebabCase: false }, 'payload'])
        : undefined;
    var payloadDataID = !inChannel
        ? bemClasses.identifier([
            { id: messageDataID, toKebabCase: false },
            'payload',
        ])
        : undefined;
    var payload = message.payload && (React.createElement(PayloadComponent, { payload: message.payload, identifier: payloadID, dataIdentifier: payloadDataID, examples: examples && getExamplesFromSpec(examples, 'payload') }));
    var content = (React.createElement(React.Fragment, null,
        headers,
        payload,
        message.bindings && (React.createElement(BindingsComponent, { bindings: message.bindings, title: MESSAGE_BINDINGS_TEXT }))));
    var isBody = !!(message.description ||
        message.headers ||
        message.payload ||
        (!hideTags && message.tags));
    var identifier = !inChannel ? messageID : undefined;
    var dataIdentifier = !inChannel ? messageDataID : undefined;
    return (React.createElement("section", { className: bemClasses.element(className), id: identifier, "data-asyncapi-id": dataIdentifier }, !inChannel ? (React.createElement(Toggle, { header: header, className: className, expanded: toggleExpand, label: ITEM_LABELS.MESSAGE, itemName: title, toggleInState: true }, !isBody ? null : (React.createElement(React.Fragment, null,
        summary,
        description,
        content)))) : (React.createElement(React.Fragment, null,
        header,
        summary,
        description,
        content))));
};
//# sourceMappingURL=Message.js.map