import React from 'react';
import { MessageComponent } from './Message';
import { bemClasses } from '../../helpers';
import { Toggle } from '../../components';
import { MESSAGES_TEXT, CONTAINER_LABELS } from '../../constants';
export var MessagesComponent = function (_a) {
    var messages = _a.messages, expand = _a.expand, _b = _a.inChannel, inChannel = _b === void 0 ? false : _b;
    if (!messages) {
        return null;
    }
    var className = CONTAINER_LABELS.MESSAGES;
    var messagesLength = Object.keys(messages).length;
    var wrapper = function (children) { return (React.createElement("section", { className: bemClasses.element(className), id: bemClasses.identifier([className]) }, children)); };
    var header = React.createElement("h2", null, MESSAGES_TEXT);
    var content = (React.createElement("ul", { className: bemClasses.element(className + "-list") }, Object.entries(messages).map(function (_a) {
        var key = _a[0], message = _a[1];
        var msg = message;
        var inferredName = msg['x-parser-message-name'] || '';
        inferredName = inferredName.includes('anonymous-message')
            ? ''
            : inferredName;
        var title = messagesLength < 2 && inChannel
            ? ''
            : message.title ||
                message.name ||
                inferredName ||
                key;
        return (React.createElement("li", { key: key, className: bemClasses.element(className + "-list-item") },
            React.createElement(MessageComponent, { title: title, message: message, hideTags: true, inChannel: false, toggleExpand: expand && expand.elements })));
    })));
    if (inChannel) {
        return wrapper(content);
    }
    return wrapper(React.createElement(Toggle, { header: header, className: className, expanded: expand && expand.root, label: CONTAINER_LABELS.MESSAGES, toggleInState: true }, content));
};
//# sourceMappingURL=Messages.js.map