import React from 'react';
import { SchemaComponent } from '../Schemas/Schema';
import { bemClasses } from '../../helpers';
import { isOneOfPayload, isAnyOfPayload } from '../../types';
import { Toggle } from '../../components';
import { ONE_OF_PAYLOADS_TEXT, ANY_OF_PAYLOADS_TEXT, PAYLOAD_TEXT, MESSAGE_PAYLOAD_TEXT, PAYLOAD_EXAMPLE_TEXT, } from '../../constants';
export var PayloadComponent = function (_a) {
    var payload = _a.payload, _b = _a.oneOf, oneOf = _b === void 0 ? false : _b, _c = _a.anyOf, anyOf = _c === void 0 ? false : _c, identifier = _a.identifier, dataIdentifier = _a.dataIdentifier, id = _a.id, examples = _a.examples;
    var className = "message-payload";
    var payloadsID = identifier ? identifier + "s" : undefined;
    if (isOneOfPayload(payload)) {
        return (React.createElement("div", { className: bemClasses.element(className + "-oneOf"), id: payloadsID, "data-asyncapi-id": dataIdentifier },
            React.createElement("header", { className: bemClasses.element(className + "-oneOf-header") },
                React.createElement("h4", null, ONE_OF_PAYLOADS_TEXT)),
            React.createElement("ul", { className: bemClasses.element(className + "-oneOf-list") }, payload.oneOf.map(function (elem, index) { return (React.createElement("li", { key: index, className: bemClasses.element(className + "-oneOf-list-item") },
                React.createElement(PayloadComponent, { payload: elem, key: index, oneOf: true, identifier: identifier, id: index, examples: examples }))); }))));
    }
    if (isAnyOfPayload(payload)) {
        return (React.createElement("div", { className: bemClasses.element(className + "-anyOf"), id: payloadsID, "data-asyncapi-id": dataIdentifier },
            React.createElement("header", { className: bemClasses.element(className + "-anyOf-header") },
                React.createElement("h4", null, ANY_OF_PAYLOADS_TEXT)),
            React.createElement("ul", { className: bemClasses.element(className + "-anyOf-list") }, payload.anyOf.map(function (elem, index) { return (React.createElement("li", { key: index, className: bemClasses.element(className + "-anyOf-list-item") },
                React.createElement(PayloadComponent, { payload: elem, key: index, anyOf: true, identifier: identifier, id: index, examples: examples }))); }))));
    }
    var inferredId = payload['x-parser-schema-id'] || '';
    inferredId = inferredId.includes('anonymous-schema') ? '' : inferredId;
    var title = id !== undefined ? (inferredId ? id + " " + inferredId : id) : PAYLOAD_TEXT;
    var header = (React.createElement("header", { className: bemClasses.element(className + "-header") },
        React.createElement("h4", null, title)));
    var content = (React.createElement("div", { className: bemClasses.element(className + "-schema") },
        React.createElement(SchemaComponent, { name: MESSAGE_PAYLOAD_TEXT, schema: payload, exampleTitle: PAYLOAD_EXAMPLE_TEXT, hideTitle: true, examples: examples })));
    var payloadID;
    if (identifier) {
        payloadID =
            payload.title && payload.title.length
                ? identifier + "-" + payload.title
                : "" + identifier + (id !== undefined ? "-" + id : '');
    }
    var payloadDataID;
    if (dataIdentifier) {
        payloadDataID =
            payload.title && payload.title.length
                ? dataIdentifier + "-" + payload.title
                : "" + dataIdentifier + (id !== undefined ? "-" + id : '');
    }
    if (oneOf || anyOf) {
        return (React.createElement("section", { className: bemClasses.element(className), id: payloadID, "data-asyncapi-id": payloadDataID },
            React.createElement(Toggle, { header: header, className: className }, content)));
    }
    return (React.createElement("section", { className: bemClasses.element(className), id: payloadID, "data-asyncapi-id": payloadDataID },
        header,
        content));
};
//# sourceMappingURL=Payload.js.map