import React from 'react';
import { SchemaPropertiesComponent as SchemaProperties } from './SchemaProperties';
import { SchemaExampleComponent } from './SchemaExample';
import { Toggle } from '../../components';
import { bemClasses, searchForNestedObject, removeSpecialChars, } from '../../helpers';
import { ITEM_LABELS, CONTAINER_LABELS } from '../../constants';
var renderSchemaProps = function (schemaName, schema, required) {
    var properties = schema.properties;
    if (properties) {
        return Object.entries(properties).map(function (_a) {
            var key = _a[0], prop = _a[1];
            return (React.createElement(SchemaProperties, { key: key, name: key, properties: prop, treeSpace: 0, required: schema.required && schema.required.includes(key) }));
        });
    }
    return (React.createElement(SchemaProperties, { name: schemaName, hasDynamicName: true, properties: schema, treeSpace: 0, required: required }));
};
export var SchemaComponent = function (_a) {
    var name = _a.name, schema = _a.schema, description = _a.description, exampleTitle = _a.exampleTitle, _b = _a.hideTitle, hideTitle = _b === void 0 ? false : _b, _c = _a.toggle, toggle = _c === void 0 ? false : _c, _d = _a.toggleExpand, toggleExpand = _d === void 0 ? false : _d, _e = _a.examples, examples = _e === void 0 ? [] : _e, _f = _a.required, required = _f === void 0 ? false : _f;
    if (!schema) {
        return null;
    }
    schema.description = schema.description || description || '';
    var className = ITEM_LABELS.SCHEMA;
    var hasNotField = searchForNestedObject(schema, 'not');
    var header = (React.createElement("h3", null,
        React.createElement("span", { className: bemClasses.element(className + "-header-title") }, name)));
    var hasExamples = examples.length;
    var content = (React.createElement(React.Fragment, null,
        React.createElement("div", { className: bemClasses.element(className + "-table") + " p-4" }, renderSchemaProps(name, schema, required)),
        hasExamples ? (examples.map(function (el, i) { return (React.createElement(SchemaExampleComponent, { title: hasExamples > 1 ? exampleTitle + " " + i : exampleTitle, example: el, key: i })); })) : hasNotField ? null : (React.createElement(SchemaExampleComponent, { title: exampleTitle, schema: schema }))));
    var schemaID = toggle
        ? bemClasses.identifier([CONTAINER_LABELS.SCHEMAS, name])
        : undefined;
    var schemaDataID = toggle
        ? bemClasses.identifier([
            CONTAINER_LABELS.SCHEMAS,
            removeSpecialChars(name),
        ])
        : undefined;
    return (React.createElement("section", { className: bemClasses.element(className), id: schemaID, "data-asyncapi-id": schemaDataID }, toggle ? (React.createElement(Toggle, { header: header, className: className, expanded: toggleExpand, label: ITEM_LABELS.SCHEMA, itemName: name, toggleInState: true }, content)) : (React.createElement(React.Fragment, null,
        hideTitle ? null : (React.createElement("header", { className: bemClasses.element(className + "-header") }, header)),
        content))));
};
//# sourceMappingURL=Schema.js.map