import React from 'react';
import { CodeComponent, Badge, BadgeType } from '../../components';
import { bemClasses, generateExampleSchema } from '../../helpers';
import { SCHEMA_EXAMPLE_TEXT } from '../../constants';
export var SchemaExampleComponent = function (_a) {
    var title = _a.title, schema = _a.schema, example = _a.example;
    var schemaExample = schema && schema.example
        ? schema.example
        : schema && generateExampleSchema(schema);
    var exampleString = JSON.stringify(example || schemaExample || '', null, 2);
    if (!exampleString) {
        return null;
    }
    return (React.createElement("div", { className: bemClasses.element("schema-example") },
        React.createElement(CodeComponent, { code: exampleString, title: React.createElement("div", { className: bemClasses.element("schema-example-header") },
                React.createElement("span", { className: bemClasses.element("schema-example-header-title") }, title ? title : SCHEMA_EXAMPLE_TEXT),
                example || (schema && schema.example) ? null : (React.createElement("div", { className: bemClasses.element("schema-example-header-generated-badge") },
                    React.createElement(Badge, { type: BadgeType.GENERATED })))) })));
};
//# sourceMappingURL=SchemaExample.js.map