import React from 'react';
import merge from 'merge';
import { bemClasses } from '../../helpers';
import { Markdown, TreeSpace, TreeLeaf } from '../../components';
var getEnumHTMLElements = function (schema) {
    var enumElements = [];
    if (schema.content.enum && schema.content.enum.length) {
        enumElements = schema.content.enum.map(function (value, i) { return (React.createElement(React.Fragment, null,
            ' ',
            React.createElement("span", { className: bemClasses.element("enum"), key: i },
                "\"",
                value,
                "\""))); });
    }
    return enumElements;
};
var handleNotProperty = function (prop) {
    if (prop.not) {
        var arrayOfChangedObjects = Object.entries(prop).map(function (_a) {
            var _b;
            var key = _a[0], val = _a[1];
            if (key === 'not') {
                return { properties: (_b = {}, _b[key] = val, _b) };
            }
            return prop[key];
        });
        return merge.recursive.apply(merge, arrayOfChangedObjects);
    }
    return prop;
};
var renderItems = function (schema, treeSpace) {
    var properties = schema.items && schema.items.properties ? schema.items.properties : null;
    if (!properties) {
        return null;
    }
    return renderProperties(schema.items, treeSpace);
};
var renderProperties = function (schema, treeSpace) {
    var properties = schema.properties;
    if (!properties) {
        return null;
    }
    return Object.entries(properties).map(function (_a) {
        var key = _a[0], prop = _a[1];
        return (React.createElement(SchemaPropertiesComponent, { key: key, name: key, properties: prop, treeSpace: treeSpace, required: schema.required && schema.required.includes(key) }));
    });
};
var renderAdditionalProperties = function (schema, treeSpace) {
    var additionalProperties = schema.additionalProperties;
    if (!additionalProperties || typeof additionalProperties === 'boolean') {
        return null;
    }
    return (React.createElement("div", null,
        React.createElement(SchemaPropertiesComponent, { key: "property-name", name: "(property name)", hasDynamicName: true, properties: additionalProperties, treeSpace: treeSpace })));
};
var renderOf = function (treeSpace, schemas) {
    if (!schemas) {
        return null;
    }
    return schemas.map(function (schema, index) {
        var id = index.toString();
        return (React.createElement(SchemaPropertiesComponent, { key: index, name: id, properties: schema, treeSpace: treeSpace }));
    });
};
var renderPropertyName = function (el) { return (React.createElement(React.Fragment, null,
    (function () {
        var treeSpaces = [];
        if (el.treeSpace) {
            for (var i = 0; i < el.treeSpace; i++) {
                treeSpaces.push(React.createElement(TreeSpace, { key: i }));
            }
            treeSpaces.push(React.createElement(TreeLeaf, { key: el.treeSpace }));
        }
        return treeSpaces;
    })(),
    el.schema.key,
    el.required && (React.createElement("div", { className: "text-red" },
        (function () {
            var treeSpaces = [];
            if (el.treeSpace) {
                for (var i = 0; i < el.treeSpace + 1; i++) {
                    treeSpaces.push(React.createElement(TreeSpace, { key: i }));
                }
            }
            return treeSpaces;
        })(),
        "required")))); };
var renderPropertyDescription = function (el) {
    var enumElements = getEnumHTMLElements(el.schema);
    return (React.createElement("div", null,
        el.schema.content.description && (React.createElement(Markdown, null, el.schema.content.description)),
        enumElements.length > 0 && React.createElement("div", null,
            "Enum: ",
            enumElements),
        el.schema.content.default && (React.createElement("div", null,
            "Default: ",
            React.createElement("span", null, el.schema.content.default))),
        el.schema.content.hasOwnProperty('const') && (React.createElement("div", null,
            "Const:",
            ' ',
            React.createElement("span", null, typeof el.schema.content.const !== 'object'
                ? String(el.schema.content.const)
                : JSON.stringify(el.schema.content.const))))));
};
export var SchemaPropertiesComponent = function (_a) {
    var name = _a.name, _b = _a.hasDynamicName, hasDynamicName = _b === void 0 ? false : _b, properties = _a.properties, treeSpace = _a.treeSpace, _c = _a.required, required = _c === void 0 ? false : _c;
    var alteredProperties = handleNotProperty(properties);
    var space = treeSpace + 1;
    var element = {
        schema: {
            key: name,
            content: alteredProperties,
        },
        treeSpace: treeSpace,
        required: required,
    };
    return (React.createElement("div", null,
        React.createElement("div", { className: "flex py-2" },
            React.createElement("div", { className: "flex-1 " + (hasDynamicName && 'font-italic') }, renderPropertyName(element)),
            React.createElement("div", { className: "flex-1" },
                React.createElement("span", { className: "capitalize text-sm text-teal font-bold" },
                    element.schema.content.type,
                    element.schema.content.anyOf
                        ? " " + element.schema.content.anyOf
                        : '',
                    element.schema.content.oneOf
                        ? " " + element.schema.content.oneOf
                        : '',
                    element.schema.content.items && element.schema.content.items.type
                        ? " (" + element.schema.content.items.type + ")"
                        : ''),
                element.schema.content.format && (React.createElement("span", { className: "bg-yellow-dark font-bold no-underline text-black rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' } }, element.schema.content.format)),
                element.schema.content.pattern && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded normal-case ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' } },
                    "must match ",
                    element.schema.content.pattern)),
                element.schema.content.uniqueItems && (React.createElement("span", { className: "bg-red-700 font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' } }, "Unique")),
                typeof element.schema.content.minItems === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At least " + element.schema.content.minItems + " items" },
                    ">= ",
                    element.schema.content.minItems,
                    " items")),
                typeof element.schema.content.maxItems === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At most " + element.schema.content.maxItems + " items" },
                    "<= ",
                    element.schema.content.maxItems,
                    " items")),
                typeof element.schema.content.minLength === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At least " + element.schema.content.minLength + " characters long" },
                    "length >= ",
                    element.schema.content.minLength)),
                typeof element.schema.content.maxLength === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At most " + element.schema.content.maxLength + " characters long" },
                    "length <= ",
                    element.schema.content.maxLength)),
                typeof element.schema.content.minimum === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At least " + element.schema.content.minimum },
                    ">= ",
                    element.schema.content.minimum)),
                typeof element.schema.content.maximum === 'number' && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "At most " + element.schema.content.maximum },
                    "<= ",
                    element.schema.content.maximum)),
                element.schema.content.exclusiveMinimum && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "Greater than " + element.schema.content.exclusiveMinimum },
                    "> ",
                    element.schema.content.exclusiveMinimum)),
                element.schema.content.exclusiveMaximum && (React.createElement("span", { className: "bg-purple-dark font-bold no-underline text-white rounded lowercase ml-2", style: { height: '20px', fontSize: '11px', padding: '3px' }, title: "Less than " + element.schema.content.exclusiveMaximum },
                    "< ",
                    element.schema.content.exclusiveMaximum)),
                React.createElement("div", { className: "py-2" }, renderPropertyDescription(element)),
                element.schema.content.type === 'object' && (React.createElement("div", { className: "font-italic text-gray-600 text-sm" },
                    (!element.schema.content.additionalProperties ||
                        typeof element.schema.content.additionalProperties ===
                            'boolean') && (React.createElement("p", { className: "my-0" },
                        "Additional properties are",
                        ' ',
                        element.schema.content.additionalProperties === false &&
                            'NOT',
                        ' ',
                        "allowed.")),
                    element.schema.content.additionalProperties &&
                        typeof element.schema.content.additionalProperties ===
                            'object' && (React.createElement("p", { className: "my-0" }, "Additional properties must adhere to the following schema.")))),
                element.schema.content.items && (React.createElement("div", { className: "font-italic text-gray-600 text-sm" }, element.schema.content.items &&
                    typeof element.schema.content.items === 'object' && (React.createElement("p", { className: "my-0" }, "Array items must adhere to the following schema.")))))),
        renderOf(space, alteredProperties.anyOf),
        renderOf(space, alteredProperties.oneOf),
        renderProperties(alteredProperties, space),
        renderAdditionalProperties(alteredProperties, space),
        renderItems(alteredProperties, space)));
};
//# sourceMappingURL=SchemaProperties.js.map