import React from 'react';
import { SchemaComponent } from './Schema';
import { bemClasses } from '../../helpers';
import { Toggle } from '../../components';
import { SCHEMAS_TEXT, CONTAINER_LABELS } from '../../constants';
export var SchemasComponent = function (_a) {
    var schemas = _a.schemas, expand = _a.expand;
    if (!schemas) {
        return null;
    }
    var className = CONTAINER_LABELS.SCHEMAS;
    var header = React.createElement("h2", null, SCHEMAS_TEXT);
    var content = (React.createElement("ul", { className: bemClasses.element(className + "-list") }, Object.entries(schemas).map(function (_a) {
        var key = _a[0], schema = _a[1];
        return (React.createElement("li", { key: key, className: bemClasses.element(className + "-list-item") },
            React.createElement(SchemaComponent, { name: key, schema: schema, toggle: true, toggleExpand: expand && expand.elements })));
    })));
    return (React.createElement("section", { className: bemClasses.element(className), id: bemClasses.identifier([className]) },
        React.createElement(Toggle, { header: header, className: className, expanded: expand && expand.root, label: CONTAINER_LABELS.SCHEMAS, toggleInState: true }, content)));
};
//# sourceMappingURL=Schemas.js.map