import React from 'react';
import { ServerSecurityFlowScopes } from './Scopes';
import { bemClasses } from '../../helpers';
import { Href } from '../../components';
import { OAuthFlowsType } from '../../types';
import { FLOWS_TEXTS } from '../../constants';
export var ServerSecurityFlow = function (_a) {
    var name = _a.name, flow = _a.flow;
    return (React.createElement("div", { className: bemClasses.element("server-security-flow") },
        React.createElement("ul", { className: bemClasses.element("server-security-flow-list") },
            React.createElement("li", { className: bemClasses.element("server-security-flow-list-item") },
                React.createElement("strong", null, FLOWS_TEXTS.FLOW),
                ":",
                React.createElement("span", null, OAuthFlowsType[name])),
            flow.authorizationUrl && (React.createElement("li", { className: bemClasses.element("server-security-flow-list-item") },
                React.createElement("strong", null,
                    FLOWS_TEXTS.AUTHORIZATION_URL,
                    ":"),
                React.createElement(Href, { href: flow.authorizationUrl }, flow.authorizationUrl))),
            flow.tokenUrl && (React.createElement("li", { className: bemClasses.element("server-security-flow-list-item") },
                React.createElement("strong", null, FLOWS_TEXTS.TOKEN_URL),
                ":",
                React.createElement(Href, { href: flow.tokenUrl }, flow.tokenUrl))),
            flow.refreshUrl && (React.createElement("li", { className: bemClasses.element("server-security-flow-list-item") },
                React.createElement("strong", null, FLOWS_TEXTS.REFRESH_URL),
                ":",
                React.createElement(Href, { href: flow.refreshUrl }, flow.refreshUrl))),
            flow.scopes && (React.createElement("li", { className: bemClasses.element("server-security-flow-list-item") },
                React.createElement("strong", null, FLOWS_TEXTS.SCOPES),
                ":",
                React.createElement(ServerSecurityFlowScopes, { scopes: flow.scopes }))))));
};
//# sourceMappingURL=Flow.js.map