import React from 'react';
import { ServerSecurityFlow } from './Flow';
import { TableRow } from '../../components';
import { bemClasses } from '../../helpers';
export var ServerSecurityFlows = function (_a) {
    var flows = _a.flows;
    if (!Object.keys(flows).length) {
        return null;
    }
    var sortedFlows = Object.keys(flows)
        .sort()
        .reduce(function (accumulator, currentValue) {
        accumulator[currentValue] = flows[currentValue];
        return accumulator;
    }, {});
    var nodes = Object.entries(sortedFlows).map(function (_a) {
        var flowName = _a[0], flow = _a[1];
        return (React.createElement("li", { key: flowName, className: bemClasses.element("server-security-flows-list-item") },
            React.createElement(ServerSecurityFlow, { name: flowName, flow: flow })));
    });
    var nestedTableCellClassName = bemClasses.modifier("nested", "table-cell");
    var flowsTableCellClassName = bemClasses.element("server-security-flows-table-cell");
    var className = bemClasses.concatenate([
        nestedTableCellClassName,
        flowsTableCellClassName,
    ]);
    var element = (React.createElement("td", { className: className, colSpan: 6 },
        React.createElement("ul", { className: bemClasses.element("server-security-flows-list") }, nodes)));
    return React.createElement(TableRow, { element: element, nested: true });
};
//# sourceMappingURL=Flows.js.map