import React from 'react';
import { ServerSecurityItemComponent } from './SecurityItem';
import { Table } from '../../components';
import { bemClasses } from '../../helpers';
import { SECURITY_TEXT, SERVER_SECURITY_COLUMN_NAMES } from '../../constants';
export var ServerSecurityComponent = function (_a) {
    var requirements = _a.requirements, schemes = _a.schemes, id = _a.identifier, dataId = _a.dataIdentifier;
    var identifier = bemClasses.identifier([
        { id: id, toKebabCase: false },
        'security',
    ]);
    var dataIdentifier = bemClasses.identifier([
        { id: dataId, toKebabCase: false },
        'security',
    ]);
    var className = "server-security";
    var rows = requirements
        .map(function (requirement) {
        var def = schemes[Object.keys(requirement)[0]];
        if (!def) {
            return null;
        }
        return (React.createElement(ServerSecurityItemComponent, { securityScheme: def, key: def.type }));
    })
        .filter(Boolean);
    if (!rows || !rows.length) {
        return null;
    }
    return (React.createElement("section", { className: bemClasses.element(className), "data-asyncapi-id": dataIdentifier, id: identifier },
        React.createElement("header", { className: bemClasses.element(className + "-header") },
            React.createElement("h4", null, SECURITY_TEXT)),
        React.createElement("div", { className: bemClasses.element(className + "-table") },
            React.createElement(Table, { header: {
                    columns: SERVER_SECURITY_COLUMN_NAMES,
                } }, rows))));
};
//# sourceMappingURL=Security.js.map