import React from 'react';
import { ServerSecurityFlows } from './Flows';
import { Markdown, TableRow } from '../../components';
import { bemClasses } from '../../helpers';
var securitySchemeAccessors = [
    function (el) { return React.createElement("span", null, el.type); },
    function (el) { return React.createElement("span", null, el.bearerFormat); },
    function (el) { return React.createElement("span", null, el.in); },
    function (el) { return React.createElement("span", null, el.scheme); },
    function (el) { return React.createElement("span", null, el.name); },
    function (el) { return el.description && React.createElement(Markdown, null, el.description); },
];
export var ServerSecurityItemComponent = function (_a) {
    var securityScheme = _a.securityScheme;
    return (React.createElement(React.Fragment, null,
        React.createElement(TableRow, { element: securityScheme, accessors: securitySchemeAccessors, className: bemClasses.element("server-security-" + securityScheme.type) }),
        securityScheme.flows && (React.createElement(ServerSecurityFlows, { flows: securityScheme.flows }))));
};
//# sourceMappingURL=SecurityItem.js.map