import React from 'react';
import { ServerVariablesComponent } from './Variables';
import { ServerSecurityComponent } from './Security';
import { BindingsComponent } from '../Bindings/Bindings';
import { bemClasses, removeSpecialChars } from '../../helpers';
import { Toggle, Markdown } from '../../components';
import { ITEM_LABELS, CONTAINER_LABELS, SERVER_BINDINGS_TEXT, } from '../../constants';
export var ServerComponent = function (_a) {
    var server = _a.server, stage = _a.stage, securitySchemes = _a.securitySchemes, _b = _a.toggleExpand, toggleExpand = _b === void 0 ? false : _b;
    var className = ITEM_LABELS.SERVER;
    var variables = server.variables
        ? Object.entries(server.variables).map(function (_a) {
            var key = _a[0], variable = _a[1];
            return ({
                key: key,
                content: variable,
            });
        })
        : [];
    var header = (React.createElement(React.Fragment, null,
        React.createElement("h4", null,
            React.createElement("span", { className: bemClasses.concatenate([
                    bemClasses.element(className + "-header-protocol"),
                    bemClasses.element("badge"),
                ]) }, "" + server.protocol + (server.protocolVersion ? " " + server.protocolVersion : "")),
            React.createElement("span", { className: bemClasses.concatenate([
                    bemClasses.element(className + "-header-stage"),
                    bemClasses.element("badge"),
                ]) }, stage),
            React.createElement("span", null, server.url))));
    var identifier = bemClasses.identifier([
        CONTAINER_LABELS.SERVERS,
        server.url,
    ]);
    var dataIdentifier = bemClasses.identifier([
        CONTAINER_LABELS.SERVERS,
        removeSpecialChars(server.url),
    ]);
    var content = (React.createElement(React.Fragment, null,
        server.description && (React.createElement("div", { className: bemClasses.element(className + "-description") },
            React.createElement(Markdown, null, server.description))),
        React.createElement(ServerVariablesComponent, { variables: variables, identifier: identifier, dataIdentifier: dataIdentifier }),
        server.security && securitySchemes && (React.createElement(ServerSecurityComponent, { requirements: server.security, schemes: securitySchemes, identifier: identifier, dataIdentifier: dataIdentifier })),
        server.bindings && (React.createElement(BindingsComponent, { bindings: server.bindings, title: SERVER_BINDINGS_TEXT }))));
    var body = (server.description || server.security || server.variables) && content;
    return (React.createElement("section", { className: bemClasses.element(className), id: identifier, "data-asyncapi-id": dataIdentifier },
        React.createElement(Toggle, { header: header, className: className, expanded: toggleExpand, label: ITEM_LABELS.SERVER, itemName: server.url, toggleInState: !!body }, body)));
};
//# sourceMappingURL=Server.js.map