import React from 'react';
import { ServerComponent } from './Server';
import { bemClasses } from '../../helpers';
import { Toggle } from '../../components';
import { SERVERS, CONTAINER_LABELS } from '../../constants';
export var ServersComponent = function (_a) {
    var servers = _a.servers, securitySchemes = _a.securitySchemes, expand = _a.expand;
    if (!servers) {
        return null;
    }
    var className = CONTAINER_LABELS.SERVERS;
    var header = React.createElement("h2", null, SERVERS);
    var content = (React.createElement("ul", { className: bemClasses.element(className + "-list") }, Object.entries(servers).map(function (_a) {
        var stage = _a[0], server = _a[1];
        return (React.createElement("li", { key: stage, className: bemClasses.element(className + "-list-item") },
            React.createElement(ServerComponent, { key: "" + server.url + stage, server: server, stage: stage, securitySchemes: securitySchemes, toggleExpand: expand && expand.elements })));
    })));
    return (React.createElement("section", { className: bemClasses.element(className), id: bemClasses.identifier([className]) },
        React.createElement(Toggle, { header: header, className: className, expanded: expand && expand.root, label: CONTAINER_LABELS.SERVERS, toggleInState: true }, content)));
};
//# sourceMappingURL=Servers.js.map