import React from 'react';
import { bemClasses } from '../../helpers';
import { Markdown, Table, } from '../../components';
import { URL_VARIABLES_TEXT, NONE_TEXT, ANY_TEXT, SERVER_COLUMN_NAMES, } from '../../constants';
var serverVariablesAccessors = [
    function (el) { return React.createElement("span", null, el.key); },
    function (el) {
        return el.content.default ? (React.createElement("span", null, el.content.default)) : (React.createElement("em", null, NONE_TEXT));
    },
    function (el) {
        return el.content.enum ? (React.createElement("ul", { className: bemClasses.element("server-variables-enum-list") }, el.content.enum.map(function (value) { return (React.createElement("li", { className: bemClasses.element("server-variables-enum-list-item"), key: value }, value)); }))) : (React.createElement("em", null, ANY_TEXT));
    },
    function (el) { return el.content.description && React.createElement(Markdown, null, el.content.description); },
];
export var ServerVariablesComponent = function (_a) {
    var variables = _a.variables, id = _a.identifier, dataId = _a.dataIdentifier;
    if (!variables.length) {
        return null;
    }
    var className = "server-variables";
    var rows = variables.map(function (variable) { return ({
        key: variable.key,
        accessors: serverVariablesAccessors,
        element: variable,
    }); });
    var identifier = bemClasses.identifier([
        { id: id, toKebabCase: false },
        'url-variables',
    ]);
    var dataIdentifier = bemClasses.identifier([
        { id: dataId, toKebabCase: false },
        'url-variables',
    ]);
    return (React.createElement("section", { className: bemClasses.element(className), id: identifier, "data-asyncapi-id": dataIdentifier },
        React.createElement("header", { className: bemClasses.element(className + "-header") },
            React.createElement("h4", null, URL_VARIABLES_TEXT)),
        React.createElement("div", { className: bemClasses.element(className + "-table") },
            React.createElement(Table, { header: {
                    columns: SERVER_COLUMN_NAMES,
                }, rows: rows }))));
};
//# sourceMappingURL=Variables.js.map