var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import merge from 'merge';
import { isRawMessage, } from '../types';
import { renderMd } from './renderMarkdown';
var Beautifier = (function () {
    function Beautifier() {
    }
    Beautifier.prototype.beautify = function (asyncApi) {
        if (asyncApi.info && asyncApi.info.description) {
            asyncApi.info.description = renderMd(asyncApi.info.description);
        }
        if (asyncApi.servers) {
            asyncApi.servers = this.beautifyServers(asyncApi.servers);
        }
        if (asyncApi.channels) {
            asyncApi.channels = this.beautifyChannels(asyncApi.channels);
        }
        if (asyncApi.components) {
            asyncApi.components.messages = this.beautifyMessages(asyncApi.components.messages);
            asyncApi.components.schemas = this.beautifySchemas(asyncApi.components.schemas);
        }
        return asyncApi;
    };
    Beautifier.prototype.resolveAllOf = function (schema) {
        var _this = this;
        if (!schema || !Object.keys(schema).length) {
            return schema;
        }
        if (schema.allOf) {
            var schemas_1 = [];
            schema.allOf.forEach(function (s) {
                schemas_1.push(_this.resolveAllOf(s) || s);
            });
            schemas_1 = schemas_1.filter(Boolean);
            return merge.recursive.apply(merge, schemas_1);
        }
        if (schema.properties) {
            var transformed = {};
            for (var _i = 0, _a = Object.entries(schema.properties); _i < _a.length; _i++) {
                var _b = _a[_i], key = _b[0], property = _b[1];
                if (typeof property !== 'object' || !property) {
                    continue;
                }
                if (property.allOf) {
                    transformed[key] = this.resolveAllOf(property) || property;
                    continue;
                }
                transformed[key] = property;
            }
            return __assign(__assign({}, schema), { properties: transformed });
        }
        return schema;
    };
    Beautifier.prototype.beautifySchema = function (schema) {
        if (!schema || !Object.keys(schema).length) {
            return schema;
        }
        if (schema.description) {
            schema.description = renderMd(schema.description);
        }
        if (schema.properties) {
            var properties = schema.properties;
            var newProperties = properties;
            for (var _i = 0, _a = Object.entries(properties); _i < _a.length; _i++) {
                var _b = _a[_i], key = _b[0], prop = _b[1];
                if (prop.description) {
                    prop.description = renderMd(prop.description);
                }
                if (prop.properties) {
                    var propProperties = prop.properties;
                    var newPropProperties = {};
                    for (var _c = 0, _d = Object.entries(propProperties); _c < _d.length; _c++) {
                        var _e = _d[_c], propKey = _e[0], propValue = _e[1];
                        newPropProperties[propKey] =
                            this.beautifySchema(propValue) || propValue;
                    }
                    prop.properties = newPropProperties;
                }
                if (prop.items) {
                    prop.items = this.beautifySchema(prop.items);
                }
                newProperties[key] = prop;
            }
            schema.properties = newProperties;
        }
        if (schema.additionalProperties) {
            var additionalProperties = schema.additionalProperties;
            var newAdditionalProperties = additionalProperties;
            for (var _f = 0, _g = Object.entries(additionalProperties); _f < _g.length; _f++) {
                var _h = _g[_f], key = _h[0], prop = _h[1];
                if (prop.description) {
                    prop.description = renderMd(prop.description);
                }
                if (typeof prop.additionalProperties === 'object' &&
                    prop.additionalProperties !== null) {
                    var propAdditionalProperties = prop.additionalProperties;
                    var newPropAdditionalProperties = {};
                    for (var _j = 0, _k = Object.entries(propAdditionalProperties); _j < _k.length; _j++) {
                        var _l = _k[_j], propKey = _l[0], propValue = _l[1];
                        newPropAdditionalProperties[propKey] =
                            this.beautifySchema(propValue) || propValue;
                    }
                    prop.properties = newPropAdditionalProperties;
                }
                newAdditionalProperties[key] = prop;
            }
            schema.additionalProperties = newAdditionalProperties;
        }
        if (schema.items) {
            schema.items = this.beautifySchema(schema.items);
        }
        return schema;
    };
    Beautifier.prototype.beautifySchemas = function (schemas) {
        if (!schemas || !Object.keys(schemas).length) {
            return schemas;
        }
        var newSchemas = {};
        for (var _i = 0, _a = Object.entries(schemas); _i < _a.length; _i++) {
            var _b = _a[_i], key = _b[0], schema = _b[1];
            if (typeof schema === 'object') {
                newSchemas[key] = this.resolveAllOf(schema) || schema;
                newSchemas[key] =
                    this.beautifySchema(newSchemas[key]) || newSchemas[key];
            }
        }
        return newSchemas;
    };
    Beautifier.prototype.beautifyMessage = function (message) {
        var _this = this;
        if (!isRawMessage(message)) {
            var beautified = __assign(__assign({}, message), { oneOf: message.oneOf.map(function (el) { return _this.beautifyMessage(el); }) });
            return beautified;
        }
        if (message.payload) {
            message.payload = this.resolveAllOf(message.payload);
            message.payload = this.beautifySchema(message.payload);
        }
        if (message.headers) {
            message.headers = this.resolveAllOf(message.headers);
        }
        if (message.summary) {
            message.summary = renderMd(message.summary);
        }
        if (message.description) {
            message.description = renderMd(message.description);
        }
        return message;
    };
    Beautifier.prototype.beautifyMessages = function (messages) {
        if (!messages || !Object.keys(messages).length) {
            return messages;
        }
        var newMessages = {};
        for (var _i = 0, _a = Object.entries(messages); _i < _a.length; _i++) {
            var _b = _a[_i], key = _b[0], message = _b[1];
            newMessages[key] = this.beautifyMessage(message);
        }
        return newMessages;
    };
    Beautifier.prototype.beautifyServers = function (servers) {
        var copiedServers = JSON.parse(JSON.stringify(servers || {}));
        Object.entries(copiedServers).forEach(function (_a) {
            var _ = _a[0], server = _a[1];
            server.description = renderMd(server.description);
            if (server.variables) {
                var variables = server.variables;
                var newVariables = variables;
                for (var _i = 0, _b = Object.entries(variables); _i < _b.length; _i++) {
                    var _c = _b[_i], key = _c[0], variable = _c[1];
                    newVariables[key].description = renderMd(variable.description);
                }
                server.variables = newVariables;
            }
        });
        return copiedServers;
    };
    Beautifier.prototype.beautifyOperation = function (operation) {
        if (operation.description) {
            operation.description = renderMd(operation.description);
        }
        if (!operation.message) {
            return operation;
        }
        return __assign(__assign({}, operation), { message: this.beautifyMessage(operation.message) });
    };
    Beautifier.prototype.beautifyChannels = function (channels) {
        var newChannels = {};
        for (var _i = 0, _a = Object.entries(channels); _i < _a.length; _i++) {
            var _b = _a[_i], key = _b[0], channel = _b[1];
            newChannels[key] = {};
            var publish = channel.publish;
            if (publish) {
                newChannels[key].publish = this.beautifyOperation(publish);
            }
            var subscribe = channel.subscribe;
            if (subscribe) {
                newChannels[key].subscribe = this.beautifyOperation(subscribe);
            }
            if (channel.parameters) {
                newChannels[key].parameters = this.beautifyParameters(channel.parameters);
            }
            newChannels[key] = channel;
        }
        return newChannels;
    };
    Beautifier.prototype.beautifyParameters = function (params) {
        var newParams = {};
        Object.entries(params).map(function (_a) {
            var key = _a[0], prop = _a[1];
            if (prop.description) {
                prop.description = renderMd(prop.description);
            }
            newParams[key] = prop;
        });
        return newParams;
    };
    return Beautifier;
}());
export var beautifier = new Beautifier();
//# sourceMappingURL=beautifier.js.map