import { CSS_PREFIX } from '../constants';
import { toKebabCase } from './toKebabCase';
var BEMCLasses = (function () {
    function BEMCLasses() {
        this.schemaID = CSS_PREFIX;
    }
    BEMCLasses.prototype.getSchemaID = function () {
        return this.schemaID;
    };
    BEMCLasses.prototype.setSchemaID = function (id) {
        this.schemaID = id ? toKebabCase(id) : this.schemaID;
    };
    BEMCLasses.prototype.element = function (element) {
        return element ? CSS_PREFIX + "__" + element : '';
    };
    BEMCLasses.prototype.modifier = function (modifier, element) {
        return modifier
            ? "" + CSS_PREFIX + (element ? "__" + element : '') + "--" + modifier
            : '';
    };
    BEMCLasses.prototype.concatenate = function (classes) {
        return classes.filter(Boolean).join(' ');
    };
    BEMCLasses.prototype.identifier = function (identifiers) {
        var _this = this;
        var id = identifiers
            .map(function (i) {
            if (!i) {
                return;
            }
            if (_this.isIdentifier(i)) {
                return i.toKebabCase ? toKebabCase(i.id) : i.id;
            }
            return i;
        })
            .filter(Boolean)
            .join('--');
        return id.startsWith(this.schemaID) ? id : this.schemaID + "--" + id;
    };
    BEMCLasses.prototype.isIdentifier = function (v) {
        return v.hasOwnProperty('id');
    };
    return BEMCLasses;
}());
export var bemClasses = new BEMCLasses();
//# sourceMappingURL=bemClasses.js.map