import { CONTAINER_LABELS } from '../constants';
var CONTAINERS_REGEX = new RegExp("(.*?)--(" + Object.values(CONTAINER_LABELS).join('|') + ")$");
var ITEMS_REGEX = new RegExp("(.*?)--(" + Object.values(CONTAINER_LABELS).join('|') + ")--(.*?)$");
var PROPERTIES_REGEX = new RegExp("(.*?)--(.*?)$");
function removeHash(str) {
    return str.startsWith('#') ? str.substr(1) : str;
}
export function extractHashData(hash) {
    var hashData = hash.match(CONTAINERS_REGEX);
    if (hashData && hashData.length === 3) {
        return {
            schema: removeHash(hashData[1]),
            container: hashData[2],
        };
    }
    hashData = hash.match(ITEMS_REGEX);
    if (!hashData || hashData.length !== 4) {
        return;
    }
    var container = hashData[2];
    var item = hashData[3];
    var itemProperties = item.match(PROPERTIES_REGEX);
    if (itemProperties && itemProperties.length === 3) {
        item = itemProperties[1];
    }
    return {
        schema: removeHash(hashData[1]),
        container: container,
        item: item,
    };
}
//# sourceMappingURL=extractHashData.js.map