import { extractHashData } from './extractHashData';
import { removeSpecialChars } from './removeSpecialChars';
function parseHashForDataId(hash) {
    var hashData = extractHashData(hash);
    if (!hashData || !Object.keys(hashData).length) {
        return;
    }
    var item = hashData.item;
    if (!item) {
        return hash;
    }
    return hash.replace('#', '').replace(item, removeSpecialChars(item));
}
export function scroll(target) {
    if (!target) {
        return;
    }
    var scrollIntoView = target.scrollIntoView;
    if (typeof scrollIntoView === 'function') {
        target.scrollIntoView(true);
        return;
    }
    var top = 0;
    while (target) {
        top += target.offsetTop;
        target = target && target.offsetParent;
    }
    window.scrollTo(0, top);
}
export function scrollIntoViewOfAnchor(hash) {
    var target;
    try {
        target = document.querySelector(hash);
        scroll(target);
    }
    catch (e) {
        try {
            setTimeout(function () {
                target = document.querySelector("[data-asyncapi-id=\"" + parseHashForDataId(hash) + "\"]");
                scroll(target);
            }, 50);
        }
        catch (error) {
            return;
        }
    }
}
//# sourceMappingURL=scrollIntoViewOfAnchor.js.map